<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Developer;
use Illuminate\Support\Str;

class DeveloperSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing data
        Developer::truncate();

        // Create developers data
        $developersData = [
            [
                'name' => 'Godrej Properties',
                'slug' => 'godrej-properties',
                'description' => 'Godrej Properties is one of India\'s leading real estate developers, known for creating premium residential and commercial spaces with world-class amenities and sustainable construction practices.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.5,
                'projects_count' => 75,
                'website_url' => 'https://www.godrejproperties.com',
                'phone' => '+91-22-2518-8999',
                'email' => 'info@godrejproperties.com',
                'sort_order' => 1,
                'status' => true,
                'meta_title' => 'Godrej Properties - Premium Real Estate Developer in India',
                'meta_description' => 'Discover luxury residential and commercial properties by Godrej Properties, India\'s trusted real estate developer with 75+ projects across major cities.',
                'meta_keywords' => 'godrej properties, real estate developer, luxury homes, commercial spaces, mumbai properties',
                'og_title' => 'Godrej Properties - Premium Real Estate Developer',
                'og_description' => 'India\'s leading real estate developer with premium residential and commercial projects.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Lodha Group',
                'slug' => 'lodha-group',
                'description' => 'Lodha Group is India\'s largest real estate developer by sales, creating iconic developments that redefine urban living with innovative design and premium amenities.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.3,
                'projects_count' => 60,
                'website_url' => 'https://www.lodhagroup.in',
                'phone' => '+91-22-6770-7000',
                'email' => 'contact@lodhagroup.in',
                'sort_order' => 2,
                'status' => true,
                'meta_title' => 'Lodha Group - India\'s Largest Real Estate Developer',
                'meta_description' => 'Explore premium residential and commercial projects by Lodha Group, India\'s largest real estate developer with 60+ iconic developments.',
                'meta_keywords' => 'lodha group, real estate developer, luxury apartments, commercial projects, mumbai developer',
                'og_title' => 'Lodha Group - India\'s Largest Real Estate Developer',
                'og_description' => 'Creating iconic developments that redefine urban living with innovative design.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'DLF Limited',
                'slug' => 'dlf-limited',
                'description' => 'DLF Limited is India\'s largest commercial real estate developer, known for creating world-class residential communities, shopping malls, and office complexes across major cities.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Gurgaon, Haryana',
                'rating' => 4.4,
                'projects_count' => 85,
                'website_url' => 'https://www.dlf.in',
                'phone' => '+91-124-4353-000',
                'email' => 'info@dlf.in',
                'sort_order' => 3,
                'status' => true,
                'meta_title' => 'DLF Limited - India\'s Largest Commercial Real Estate Developer',
                'meta_description' => 'Discover world-class residential communities and commercial spaces by DLF Limited, India\'s leading real estate developer with 85+ projects.',
                'meta_keywords' => 'dlf limited, commercial real estate, residential communities, shopping malls, gurgaon developer',
                'og_title' => 'DLF Limited - India\'s Largest Commercial Real Estate Developer',
                'og_description' => 'Creating world-class residential communities and commercial spaces across India.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Tata Housing',
                'slug' => 'tata-housing',
                'description' => 'Tata Housing Development Company is committed to creating sustainable communities with innovative design, green building practices, and world-class amenities for modern living.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.2,
                'projects_count' => 45,
                'website_url' => 'https://www.tatahousing.in',
                'phone' => '+91-22-6665-8282',
                'email' => 'info@tatahousing.in',
                'sort_order' => 4,
                'status' => true,
                'meta_title' => 'Tata Housing - Sustainable Communities & Green Buildings',
                'meta_description' => 'Explore sustainable residential projects by Tata Housing with innovative design and green building practices across 45+ developments.',
                'meta_keywords' => 'tata housing, sustainable communities, green buildings, residential projects, mumbai developer',
                'og_title' => 'Tata Housing - Sustainable Communities & Green Buildings',
                'og_description' => 'Creating sustainable communities with innovative design and green building practices.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Sobha Limited',
                'slug' => 'sobha-limited',
                'description' => 'Sobha Limited is renowned for its backward integration model and superior construction quality, creating premium residential and commercial spaces with attention to detail.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Bangalore, Karnataka',
                'rating' => 4.6,
                'projects_count' => 52,
                'website_url' => 'https://www.sobha.com',
                'phone' => '+91-80-4933-6000',
                'email' => 'info@sobha.com',
                'sort_order' => 5,
                'status' => true,
                'meta_title' => 'Sobha Limited - Premium Real Estate with Superior Quality',
                'meta_description' => 'Discover premium residential and commercial spaces by Sobha Limited, known for superior construction quality and attention to detail.',
                'meta_keywords' => 'sobha limited, premium real estate, construction quality, residential projects, bangalore developer',
                'og_title' => 'Sobha Limited - Premium Real Estate with Superior Quality',
                'og_description' => 'Creating premium spaces with superior construction quality and attention to detail.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Prestige Group',
                'slug' => 'prestige-group',
                'description' => 'Prestige Group is a leading real estate developer in South India, known for creating landmark residential, commercial, retail, and hospitality projects with innovative architecture.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Bangalore, Karnataka',
                'rating' => 4.3,
                'projects_count' => 68,
                'website_url' => 'https://www.prestigeconstructions.com',
                'phone' => '+91-80-2572-0000',
                'email' => 'info@prestigeconstructions.com',
                'sort_order' => 6,
                'status' => true,
                'meta_title' => 'Prestige Group - Leading Real Estate Developer in South India',
                'meta_description' => 'Explore landmark residential and commercial projects by Prestige Group, South India\'s leading real estate developer with 68+ developments.',
                'meta_keywords' => 'prestige group, south india developer, residential projects, commercial spaces, bangalore properties',
                'og_title' => 'Prestige Group - Leading Real Estate Developer in South India',
                'og_description' => 'Creating landmark residential and commercial projects with innovative architecture.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Brigade Group',
                'slug' => 'brigade-group',
                'description' => 'Brigade Group is a pioneer in real estate development, creating integrated townships, premium residential complexes, and world-class commercial spaces across South India.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Bangalore, Karnataka',
                'rating' => 4.1,
                'projects_count' => 55,
                'website_url' => 'https://www.brigadegroup.com',
                'phone' => '+91-80-4137-4000',
                'email' => 'info@brigadegroup.com',
                'sort_order' => 7,
                'status' => true,
                'meta_title' => 'Brigade Group - Integrated Townships & Premium Developments',
                'meta_description' => 'Discover integrated townships and premium residential complexes by Brigade Group, a pioneer in real estate development with 55+ projects.',
                'meta_keywords' => 'brigade group, integrated townships, premium residential, commercial spaces, bangalore developer',
                'og_title' => 'Brigade Group - Integrated Townships & Premium Developments',
                'og_description' => 'Creating integrated townships and premium residential complexes across South India.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Mahindra Lifespace',
                'slug' => 'mahindra-lifespace',
                'description' => 'Mahindra Lifespace Developers is committed to creating sustainable urban spaces and thriving communities with a focus on environmental consciousness and quality living.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.0,
                'projects_count' => 35,
                'website_url' => 'https://www.mahindralifespaces.com',
                'phone' => '+91-22-6747-8888',
                'email' => 'info@mahindralifespaces.com',
                'sort_order' => 8,
                'status' => true,
                'meta_title' => 'Mahindra Lifespace - Sustainable Urban Spaces & Communities',
                'meta_description' => 'Explore sustainable urban developments by Mahindra Lifespace, focused on environmental consciousness and quality living across 35+ projects.',
                'meta_keywords' => 'mahindra lifespace, sustainable urban spaces, environmental consciousness, quality living, mumbai developer',
                'og_title' => 'Mahindra Lifespace - Sustainable Urban Spaces & Communities',
                'og_description' => 'Creating sustainable urban spaces with environmental consciousness and quality living.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Oberoi Realty',
                'slug' => 'oberoi-realty',
                'description' => 'Oberoi Realty is known for developing luxury residential and commercial properties with world-class amenities, exceptional design, and premium locations in Mumbai.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.7,
                'projects_count' => 25,
                'website_url' => 'https://www.oberoirealty.com',
                'phone' => '+91-22-6123-4567',
                'email' => 'info@oberoirealty.com',
                'sort_order' => 9,
                'status' => true,
                'meta_title' => 'Oberoi Realty - Luxury Properties in Premium Mumbai Locations',
                'meta_description' => 'Discover luxury residential and commercial properties by Oberoi Realty, featuring world-class amenities and exceptional design in Mumbai.',
                'meta_keywords' => 'oberoi realty, luxury properties, premium locations, mumbai real estate, world-class amenities',
                'og_title' => 'Oberoi Realty - Luxury Properties in Premium Mumbai Locations',
                'og_description' => 'Developing luxury properties with world-class amenities and exceptional design.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
            [
                'name' => 'Hiranandani Group',
                'slug' => 'hiranandani-group',
                'description' => 'Hiranandani Group is a pioneering real estate developer known for creating integrated townships, luxury residential projects, and commercial complexes with modern infrastructure.',
                'logo' => 'img/no-property-image.jpeg',
                'location' => 'Mumbai, Maharashtra',
                'rating' => 4.4,
                'projects_count' => 40,
                'website_url' => 'https://www.hiranandani.com',
                'phone' => '+91-22-6778-9000',
                'email' => 'info@hiranandani.com',
                'sort_order' => 10,
                'status' => true,
                'meta_title' => 'Hiranandani Group - Integrated Townships & Luxury Developments',
                'meta_description' => 'Explore integrated townships and luxury residential projects by Hiranandani Group, a pioneering real estate developer with 40+ projects.',
                'meta_keywords' => 'hiranandani group, integrated townships, luxury residential, commercial complexes, mumbai developer',
                'og_title' => 'Hiranandani Group - Integrated Townships & Luxury Developments',
                'og_description' => 'Creating integrated townships and luxury developments with modern infrastructure.',
                'og_image' => 'img/no-property-image.jpeg',
            ],
        ];

        // Insert data into the database
        foreach ($developersData as $data) {
            Developer::create($data);
        }

        $this->command->info('Developer seeder completed successfully!');
    }
}
