<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Investment Opportunities</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('investment-opportunities.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Investment Opportunity
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Location</th>
                                    <th>Price Range</th>
                                    <th>Developer</th>
                                    <th>Rating</th>
                                    <th>Status</th>
                                    <th>Sort Order</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $opportunities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opportunity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($opportunity->id); ?></td>
                                        <td>
                                            <?php if($opportunity->image_url): ?>
                                                <img src="<?php echo e($opportunity->image_url); ?>" alt="<?php echo e($opportunity->title); ?>" class="img-thumbnail" style="width: 60px; height: 60px;">
                                            <?php else: ?>
                                                <span class="text-muted">No Image</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($opportunity->title); ?></td>
                                        <td><?php echo e($opportunity->location); ?></td>
                                        <td><?php echo e($opportunity->price_range); ?></td>
                                        <td><?php echo e($opportunity->developer_name); ?></td>
                                        <td>
                                            <div class="rating">
                                                <?php echo $opportunity->star_rating; ?>

                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge badge-<?php echo e($opportunity->status ? 'success' : 'danger'); ?>">
                                                <?php echo e($opportunity->status ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($opportunity->sort_order); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('investment-opportunities.show', $opportunity)); ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('investment-opportunities.edit', $opportunity)); ?>" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('investment-opportunities.destroy', $opportunity)); ?>" method="POST" style="display: inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this investment opportunity?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="10" class="text-center">No investment opportunities found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($opportunities->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.rating i {
    color: #ffc107;
    font-size: 14px;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/investment-opportunities/index.blade.php ENDPATH**/ ?>