<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Property Update</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Property Update</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <form id="update_property_form" action="<?php echo e(route('property.update', $property->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">General Details</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="property_title"><?php echo e(__('Property Title')); ?> </label>
                            <input 
                                type="text" 
                                value="<?php echo e($property->property_title); ?>"
                                name="property_title" 
                                class="form-control <?php $__errorArgs = ['property_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_title" 
                                placeholder="Enter Property name">
                            <?php $__errorArgs = ['property_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_slug"><?php echo e(__('Property Slug')); ?> (Without spaces)</label>
                            <input 
                                type="text" 
                                value="<?php echo e($property->property_slug); ?>"
                                name="property_slug" 
                                class="form-control <?php $__errorArgs = ['property_slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_slug" 
                                placeholder="Enter Property Slug">
                            <?php $__errorArgs = ['property_slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_logo"><?php echo e(__('Property Logo') . '*'); ?></label>
                            <br>
                            <?php if(isset($property->property_logo)): ?>
                            <div class="shrink-0 my-2">
                                <span>File Exists: </span>
                                <div class="thumb-preview ">
                                    <a href="<?php echo e(Storage::url($property->property_logo)); ?>">
                                        <img width="40%" src="<?php echo e(asset('assets/img/property/propertylogo/'.$property->property_logo)); ?>" alt="..." class="uploaded-img img-thumbnail">
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="thumb-preview ">
                                <img src="<?php echo e(asset('assets/admin/dist/img/noimage.jpg')); ?>" alt="..."
                                     class="uploaded-img img-thumbnail">
                            </div>
                            <?php endif; ?>
                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" class="img-input" id="property_logo" name="property_logo" accept="image/png, image/jpeg">
                                </div>
                            </div>
                            <?php $__errorArgs = ['property_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_favicon"><?php echo e(__('Property Favicon') . '*'); ?></label>
                            <br>
                            <?php if(isset($property->property_favicon)): ?>
                            <div class="shrink-0 my-2">
                                <span>File Exists: </span>
                                <div class="thumb-preview ">
                                    <a href="<?php echo e(Storage::url($property->property_favicon)); ?>">
                                        <img width="40%" src="<?php echo e(asset('assets/img/property/propertyfavicon/'.$property->property_favicon)); ?>" alt="..." class="uploaded-img img-thumbnail">
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="favicon-preview">
                                <img src="<?php echo e(asset('assets/admin/dist/img/noimage.jpg')); ?>" alt="..."
                                     class="uploaded-img img-thumbnail">
                            </div>
                            <?php endif; ?>
                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" class="img-input" id="property_favicon" name="property_favicon" accept="image/*">
                                </div>
                            </div>
                            <?php $__errorArgs = ['property_favicon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_color"><?php echo e(__('Property Theme color')); ?> </label>
                            <input 
                                type="text" 
                                value="<?php echo e($property->property_color); ?>"
                                name="property_color"
                                class="form-control <?php $__errorArgs = ['property_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_color">
                            <?php $__errorArgs = ['property_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="mobile_no"><?php echo e(__('Property Mobile Number')); ?> </label>
                            <input 
                                type="text" 
                                name="mobile_no"
                                value="<?php echo e($property->mobile_no); ?>"
                                class="form-control <?php $__errorArgs = ['mobile_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="mobile_no">
                            <?php $__errorArgs = ['mobile_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <div class="form-check">
                                <input 
                                    class="form-check-input <?php $__errorArgs = ['top_selling'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    type="checkbox" 
                                    value="1" 
                                    name="top_selling" 
                                    id="top_selling"
                                    <?php echo e(($property->top_selling ?? old('top_selling')) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="top_selling">
                                    <?php echo e(__('Show in Top Selling Projects')); ?>

                                </label>
                                <?php $__errorArgs = ['top_selling'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="form-text text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Banner Section</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="pre_launch_text">Pre launch Offer Text</label>
                            <input 
                                type="text" 
                                name="pre_launch_text" 
                                value="<?php echo e($property->pre_launch_text); ?>"
                                class="form-control <?php $__errorArgs = ['pre_launch_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="pre_launch_text" 
                                placeholder="Enter Pre launch Offer Text">
                            <?php $__errorArgs = ['pre_launch_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_location">Property Location</label>
                            <input 
                                type="text" 
                                name="property_location" 
                                value="<?php echo e($property->property_location); ?>"
                                class="form-control <?php $__errorArgs = ['property_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_location" 
                                placeholder="Enter Property Location">
                            <?php $__errorArgs = ['property_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="city_id"><?php echo e(__('City')); ?> <span class="text-danger">*</span></label>
                            <select 
                                name="city_id" 
                                class="form-control <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="city_id">
                                <option value="">Select City</option>
                                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($city->id); ?>" <?php echo e(($property->city_id ?? old('city_id')) == $city->id ? 'selected' : ''); ?>>
                                        <?php echo e($city->title); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="by_developer_text">Property By Developer Text</label>
                            <input 
                                type="text" 
                                name="by_developer_text" 
                                value="<?php echo e($property->by_developer_text); ?>"
                                class="form-control <?php $__errorArgs = ['by_developer_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="by_developer_text" 
                                placeholder="Enter Developer By Text">
                            <?php $__errorArgs = ['by_developer_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_exclusive_text">Property Exclusive Text</label>
                            <input 
                                type="text" 
                                name="property_exclusive_text" 
                                value="<?php echo e($property->property_exclusive_text); ?>"
                                class="form-control <?php $__errorArgs = ['property_exclusive_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_exclusive_text" 
                                placeholder="Enter Property Exclusive Text">
                            <?php $__errorArgs = ['property_exclusive_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_price">Property Start Price Text</label>
                            <input 
                                type="text" 
                                name="property_price" 
                                value="<?php echo e($property->property_price); ?>"
                                class="form-control <?php $__errorArgs = ['property_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_price" 
                                placeholder="Enter Property Price">
                            <?php $__errorArgs = ['property_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="banner-photo-add">Banner Images (Select mutiple images to upload images)</label>
                            <input type="file" accept="image/*" class="form-control" name="banners[]" multiple id="banner-photo-add">
                            <div class="col-lg-12 col-md-12 col-xs-12 xol-sm-12">
                                <output id="list"></output>
                            </div>
                            <div class="banners">
                                <div class="row">
                                <?php $__empty_1 = true; $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="thumb-preview col-sm-4">
                                    <a href="javascript:void(0)" data-url="<?php echo e(route('property.bannerdelete', $slide->id)); ?>" class="btn btn-danger remove-banner">Delete</a>
                                    <img width="100%" src="<?php echo e(asset('assets/img/property/banners/'.$slide->image)); ?>" alt="..."
                                         class="uploaded-img">
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p>No Images Found.</p>
                                <?php endif; ?>
                            </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="banner_content">Left Side Banner buttons</label>
                            <div id="summernote"></div>
                            <textarea 
                                class="summernote <?php $__errorArgs = ['banner_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="banner_content" 
                                id="banner_content" 
                                placeholder="Banner content"><?php echo e($property->banner_content); ?></textarea>
                            <?php $__errorArgs = ['banner_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">About Project Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="property_short_desc">About us Subtitle</label>
                            <textarea 
                                class="form-control <?php $__errorArgs = ['property_short_desc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="property_short_desc" 
                                id="property_short_desc" 
                                placeholder="Property Short description"><?php echo e($property->property_short_desc); ?></textarea>
                            <?php $__errorArgs = ['property_short_desc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_desc">Project Description</label>
                            <!--<div id="summernote"></div>-->
                            <textarea 
                                class="summernote <?php $__errorArgs = ['property_desc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="property_desc" 
                                id="property_desc" 
                                placeholder="Property description"><?php echo e($property->property_desc); ?></textarea>
                            <?php $__errorArgs = ['property_desc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_highlights">Project Highlights</label>
                            <!--<div id="summernote"></div>-->
                            <textarea 
                                class="summernote <?php $__errorArgs = ['property_highlights'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="property_highlights" 
                                id="property_highlights" 
                                placeholder="Property highlights"><?php echo e($property->property_highlights); ?></textarea>
                            <?php $__errorArgs = ['property_highlights'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_video_url">Property Video URL(Youtube embeded code):</label>
                            <input 
                                type="text" 
                                name="property_video_url" 
                                value="<?php echo e($property->property_video_url); ?>"
                                class="form-control <?php $__errorArgs = ['property_video_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_video_url" 
                                placeholder="Enter Property video URL">
                            <?php $__errorArgs = ['property_video_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Price Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="complete_costing_details"><?php echo e(__('Complete Costing Details ') . '*'); ?></label>
                            <br>
                            <div class="complete-costing-preview"></div>

                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" accept="image/*" class="img-input" id="complete_costing_details" name="complete_costing_details">
                                </div>
                            </div>
                            <?php $__errorArgs = ['complete_costing_details'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <table class="table table-striped table-borderless border micro-price-table table-pricing">
                                <thead>
                                    <tr>
                                        <th scope="col" class="border border-bottom-0 mb-w">Type</th>
                                        <th scope="col" class="border border-bottom-0 mb-w">Carpet Area</th>
                                        <th scope="col" class="border border-bottom-0 border-right-0">Price</th>
                                        <th scope="col">Image:</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (!empty($floors)) {
                                        foreach ($floors as $floor) :
                                          if(isset($floor['flat_type'])) :
                                            ?>
                                              <tr> 
                                                <td class="border border-left-0 border-top-0 border-bottom-0 price-type"><?= $floor['flat_type'] ?></td> 
                                                <td class="border border-left-0 border-top-0 border-bottom-0 price-carpet"><?= $floor['carpet_area']; ?><small class="d-inline-block d-md-none">(Carpet Area)</small></td> 
                                                <td class="price-amt"><i class="mi mi-rs-light"></i> <?= $floor['flat_price']; ?></td>
                                                <td><img width="40%" src="<?php echo e(asset('assets/img/property/floorimage/'.$floor->image)); ?>" alt="..."></td>
                                              </tr>
                                          <?php endif;
                                        endforeach;
                                    }
                                    ?>
                                </tbody>
                            </table>
                            <div class="cloneData">
                                <div class="row">
                                    <div class="col-md-2">
                                        <label for="flat_type">Flat type</label>
                                        <input 
                                            type="text" 
                                            name="flat_type[]" 
                                            class="form-control <?php $__errorArgs = ['flat_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="flat_type" 
                                            placeholder="Enter Flat Type">
                                        <?php $__errorArgs = ['flat_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="form-text text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="carpet_area">Carpet Area</label>
                                        <input 
                                            type="text" 
                                            name="carpet_area[]" 
                                            class="form-control <?php $__errorArgs = ['carpet_area'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="carpet_area" 
                                            placeholder="Enter carpet area">
                                        <?php $__errorArgs = ['carpet_area'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="form-text text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="flat_price">Price</label>
                                        <input 
                                            type="text" 
                                            name="flat_price[]" 
                                            class="form-control <?php $__errorArgs = ['flat_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="flat_price" 
                                            placeholder="Enter Flat Price">
                                        <?php $__errorArgs = ['flat_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="form-text text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="floor_image">Floor Image</label>
                                        <input 
                                            type="file" 
                                            accept="image/*"
                                            name="floor_image[]"
                                            class="form-control <?php $__errorArgs = ['floor_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="floor_image" >
                                        <?php $__errorArgs = ['floor_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="form-text text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <button type="button" id="addRow" class="btn btn-primary add-price mt-2">Add New</button>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Site and Floor Plan Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="master_plan_image"><?php echo e(__('Master Plan Image') . '*'); ?></label>
                            <?php if(isset($property->master_plan_image)): ?>
                            <div class="shrink-0 my-2">
                                <span>File Exists: </span>
                                <div class="thumb-preview ">
                                    <a href="<?php echo e(Storage::url($property->master_plan_image)); ?>">
                                        <img width="40%" src="<?php echo e(asset('assets/img/property/masterplanimage/'.$property->master_plan_image)); ?>" alt="..." class="img-thumbnail">
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="thumb-preview ">
                                <img src="<?php echo e(asset('assets/admin/dist/img/noimage.jpg')); ?>" alt="..."
                                     class="uploaded-img">
                            </div>
                            <?php endif; ?>
                            <br>
                            <div class="master_plan_image_preview"></div>

                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" accept="image/*" class="img-input" id="master_plan_image" name="master_plan_image">
                                </div>
                            </div>
                            <?php $__errorArgs = ['master_plan_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="property_brochure">Property brochure</label>
                    <input 
                        type="text" 
                        name="property_brochure" 
                        value="<?php echo e($property->property_brochure); ?>"
                        class="form-control <?php $__errorArgs = ['property_brochure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                        id="property_brochure" 
                        placeholder="Enter Property brochure URL">
                    <?php $__errorArgs = ['property_brochure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="form-text text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="form-group">
                    <label for="status">Status</label>
                    <select name="status"  id="status" class="form-control custom-select">
                        <option selected="" disabled="">Select one</option>
                        <option value="1" <?php echo e("1" == $property->status ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e("0" == $property->status ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="form-text text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Sidebar Section Content</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="sidebar_content">Sidebar Register Content</label>
                            <div id="summernote"></div>
                            <textarea 
                                class="summernote <?php $__errorArgs = ['sidebar_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="sidebar_content" 
                                id="sidebar_content" 
                                placeholder="Banner content"><?php echo e($property->sidebar_content); ?></textarea>
                            <?php $__errorArgs = ['sidebar_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Amenities Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="property_amenities">Amenities (Enter with comma seprated like: swimming pool, kids pool )</label>
                            <input 
                                type="text" 
                                name="property_amenities" 
                                value="<?php echo e($property->property_amenities); ?>"
                                class="form-control <?php $__errorArgs = ['property_amenities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_amenities" 
                                placeholder="Enter Property amenities in comma format">
                            <?php $__errorArgs = ['property_amenities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Upload Gallery Image</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="gallery-photo-add">Select multiple images for gallery</label>
                            <input type="file" accept="image/*" class="form-control" name="gallery[]" multiple id="gallery-photo-add">
                        </div>
                            <div class="row">
                              <?php $__empty_1 = true; $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="thumb-preview-gallery col-sm-4">
                                <span>Gallery: </span><br />
                                <a href="javascript:void(0)" data-url="<?php echo e(route('property.gallerydelete', $ga->id)); ?>" class="btn btn-danger remove-gallery">Delete</a>
                                <img width="40%" src="<?php echo e(asset('assets/img/property/gallery/'.$ga->image)); ?>" alt="..."
                                     class="uploaded-img">
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p>No Images Found.</p>
                            <?php endif; ?>
                            </div>
                        <div class="gallery"></div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Location Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="map_embed_url">Property Map URL</label>
                            <input 
                                type="text" 
                                name="map_embed_url" 
                                value="<?php echo e($property->map_embed_url); ?>"
                                class="form-control <?php $__errorArgs = ['map_embed_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="map_embed_url">
                            <?php $__errorArgs = ['map_embed_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="location_text">Locations Text</label>
                            <?php
                            $locationText = $property->location_text;
                            $locationTextArray = [];
                            if (!empty($locationText)) {
                              $locationTextArray = explode(",", $locationText);
                            }
                            ?>
                            <?php
                            $filteredArray = array_filter($locationTextArray, fn($value) => !is_null($value) && $value !== ' ');
                            foreach ($filteredArray as $key => $l) {
                              ?>
                              <div class="row location-box">
                                  <div class="col-sm-9 my-2">
                                      <?= $l; ?> 
                                  </div>
                                  <div class="col-sm-2 my-2">
                                      <a href="javascript:void(0)" data-val="<?= $l; ?>" data-id="<?php echo e($property->id); ?>" class="btn btn-danger remove-location">Delete</a>
                                  </div>
                                  <input type="hidden" name="location_text[]" value="<?= $l; ?>" >
                              </div>
                              <?php
                            }
                            ?>
                            <div class="cloneData1">
                                <div class="row mb-2">
                                    <div class="col-md-10">
                                        <input 
                                            type="text" 
                                            name="location_text[]" 
                                            class="form-control <?php $__errorArgs = ['location_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="location_text" 
                                            placeholder="Enter Near Location Details">
                                        <?php $__errorArgs = ['location_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="form-text text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <button type="button" id="addRow1" class="btn btn-primary add-location mt-2">Add New</button>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Virtual Site Tour Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="virtual_site_tour">Property virtual site tour image:</label>
                            <?php if(isset($property->virtual_site_tour)): ?>
                            <div class="shrink-0 my-2">
                                <span>File Exists: </span>
                                <div class="thumb-preview-tour">
                                    <a href="<?php echo e(Storage::url($property->virtual_site_tour)); ?>">
                                        <img width="40%" src="<?php echo e(asset('assets/img/property/virtualsitetour/'.$property->virtual_site_tour)); ?>" alt="..." class="uploaded-img img-thumbnail">
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="thumb-preview-tour">
                                <img src="<?php echo e(asset('assets/admin/dist/img/noimage.jpg')); ?>" alt="..."
                                     class="uploaded-img img-thumbnail">
                            </div>
                            <?php endif; ?>

                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" class="img-input" id="virtual_site_tour" name="virtual_site_tour" accept="image/*">
                                </div>
                            </div>
                            <?php $__errorArgs = ['virtual_site_tour'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Developer Details Section</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="builder_name">Developer Name</label>
                            <input 
                                type="text" 
                                value="<?php echo e($property->builder_name); ?>"
                                name="builder_name" 
                                class="form-control <?php $__errorArgs = ['builder_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="builder_name" 
                                placeholder="Enter Developer Name">
                            <?php $__errorArgs = ['builder_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="developer_logo">Developer Logo</label>
                            <br>
                            <div class="developer-logo-preview">
                                <?php if($property->developer_logo): ?>
                                    <img src="<?php echo e(asset('assets/img/property/developer/' . $property->developer_logo)); ?>" 
                                         alt="Developer Logo" class="uploaded-img" style="width: 100px; height: 100px; object-fit: cover; border-radius: 8px;">
                                <?php endif; ?>
                            </div>
                            <div class="mt-3">
                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                    <input type="file" class="img-input" id="developer_logo" name="developer_logo" accept="image/*">
                                </div>
                            </div>
                            <?php $__errorArgs = ['developer_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="about_developer">Developer About</label>
                            <textarea 
                                class="summernote <?php $__errorArgs = ['about_developer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="about_developer" 
                                id="about_developer" 
                                placeholder="Developer About"><?php echo e($property->about_developer); ?></textarea>
                            <?php $__errorArgs = ['about_developer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="property_rera_no">Property Rera No.</label>
                            <input 
                                type="text" 
                                name="property_rera_no" 
                                value="<?php echo e($property->property_rera_no); ?>"
                                class="form-control <?php $__errorArgs = ['property_rera_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="property_rera_no" 
                                placeholder="Enter Property Rera No.">
                            <?php $__errorArgs = ['property_rera_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Footer Section</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="property_footer_content">Property Footer Content</label>
                            <!--<div id="summernote"></div>-->
                            <textarea 
                                class="summernote <?php $__errorArgs = ['property_footer_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="property_footer_content" 
                                id="property_footer_content" 
                                placeholder="Property Content"><?php echo e($property->property_footer_content); ?></textarea>
                            <?php $__errorArgs = ['property_footer_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="card card-secondary">
                    <div class="card-header">
                        <h3 class="card-title">Meta Details</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="meta_title">Meta Title</label>
                            <input 
                                type="text" 
                                name="meta_title" 
                                value="<?php echo e($property->meta_title); ?>"
                                class="form-control <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="meta_title" >
                            <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="meta_keywords">Meta Keywords</label>
                            <input 
                                type="text" 
                                name="meta_keywords" 
                                value="<?php echo e($property->meta_keywords); ?>"
                                class="form-control <?php $__errorArgs = ['meta_keywords'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="meta_keywords" >
                            <?php $__errorArgs = ['meta_keywords'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="meta_description">Meta Description</label>
                            <input 
                                type="text" 
                                name="meta_description" 
                                value="<?php echo e($property->meta_description); ?>"
                                class="form-control <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="meta_description" >
                            <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="social_meta_tags">Social Meta Tags</label>
                            <textarea 
                                class="form-control  <?php $__errorArgs = ['social_meta_tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                style="height:150px" 
                                name="social_meta_tags" 
                                id="social_meta_tags" ><?php echo e($property->social_meta_tags); ?></textarea>
                            <?php $__errorArgs = ['social_meta_tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="form-text text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <a href="#" class="btn btn-secondary">Cancel</a>
                <input type="submit" value="Update details" class="btn btn-success float-right">
            </div>
        </div>
    </form>
</section>
<script>
    $(document).on("change", "#bgcolor", function () {
        $('#property_color').val($(this).val());
    });
    $(function () {
      
        // Multiple images preview in browser
        var imagesPreview = function (input, placeToInsertImagePreview) {
            if (input.files) {
                var filesAmount = input.files.length;
                for (i = 0; i < filesAmount; i++) {
                  var id = $(input.files[i]).attr('id') || 1;
                  console.log("ID",id)
                    var reader = new FileReader();
                    reader.onload = function (event) {
                        $($.parseHTML('<img class="img-fluid mr-2" width="200px" />')).attr({
                            'src' : event.target.result,
                            'data-id' : "img-" + id
                        }).appendTo(placeToInsertImagePreview);
                    }
                    reader.readAsDataURL(input.files[i]);
                }
            }
        };
        var singleImagesPreview = function (input, placeToInsertImagePreview) {
        console.log(input, placeToInsertImagePreview)
            if (input.files) {
                    var reader = new FileReader();
                    reader.onload = function (event) {
                       $(placeToInsertImagePreview).attr("src", event.target.result);
//                        $($.parseHTML('<img class="img-fluid mr-2" width="200px" />')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                    }
                    reader.readAsDataURL(input.files[0]);
            }
        };
        
        function deleteImage() { 
            var index = Array.from(document.getElementById('list').children).indexOf(event.target.parentNode)
            document.querySelector("#list").removeChild( document.querySelectorAll('#list span')[index]);
            totalFiles.splice(index, 1);
            console.log(totalFiles)
        }

        var totalFiles = [];
        function handleFileSelect(evt) {
            var files = evt.target.files; // FileList object

            // Loop through the FileList and render image files as thumbnails.
            for (var i = 0, f; f = files[i]; i++) {

              // Only process image files.
              if (!f.type.match('image.*')) {
                continue;
              }

              totalFiles.push(f)

              var reader = new FileReader();

              // Closure to capture the file information.
              reader.onload = (function(theFile) {
                return function(e) {
                  // Render thumbnail.
                  var span = document.createElement('span');
                  span.innerHTML = ['<img width=100 class="thumb" src="', e.target.result,
                                    '" title="', escape(theFile.name), '"/>', "<button onclick='deleteImage()'>delete</button>"].join('');

                  document.getElementById('list').insertBefore(span, null);
                };
              })(f);

              // Read in the image file as a data URL.
              reader.readAsDataURL(f);
            }
          }
        $('#property_logo').on('change', function () {
            singleImagesPreview(this, '.thumb-preview .uploaded-img');
        });
         $('#property_favicon').on('change', function () {
            singleImagesPreview(this, '.favicon-preview .uploaded-img');
        });
        $('#developer_logo').on('change', function () {
            singleImagesPreview(this, '.developer-logo-preview .uploaded-img');
        });
        $('#virtual_site_tour').on('change', function () {
            singleImagesPreview(this, '.thumb-preview-tour .uploaded-img');
        });
        $('#gallery-photo-add').on('change', function () {
            imagesPreview(this, 'div.gallery');
        });
//        $('#banner-photo-add').on('change', function () {
//            handleFileSelect(this, 'div.banners');
//        });
          document.getElementById('banner-photo-add').addEventListener('change', handleFileSelect, false);
        $("#addRow").on('click', function () {
            let $cloneData = $('.cloneData .row:first').clone();
            $cloneData.append('<div class="col-sm-2"><button type="button" class="btn btn-danger button-remove mt-4">Remove</button>');
            $cloneData.appendTo(".cloneData");
        });

        // remove row
        $(document).on("click", ".button-remove", function () {
            $(this).closest(".row").remove();
        });

        $("#addRow1").on('click', function () {
            let $cloneData = $('.cloneData1 .row:first').clone();
            $cloneData.append('<div class="col-sm-2"><button type="button" class="btn btn-danger button-remove1">Remove</button>');
            $cloneData.appendTo(".cloneData1");
        });

        // remove row
        $(document).on("click", ".button-remove1", function () {
            $(this).closest(".row").remove();
        });

        $.ajaxSetup({
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-CSRF-TOKEN', $('input[name="_token"]').val());
            }
        });

        /*------------------------------------------
        --------------------------------------------
        When click user on Delete Button
        --------------------------------------------
        --------------------------------------------*/
        $(document).on('click', '.remove-banner', function() {

            var userURL = $(this).data('url');
            var trObj = $(this);

            if (confirm("Are you sure you want to delete this banner?") == true) {
                $.ajax({
                    url: userURL,
                    type: 'DELETE',
                    dataType: 'json',
                    success: function(data) {
//                        alert(data.success);
                        trObj.closest(".thumb-preview").remove();
                    }
                });
            }
        });
        $(document).on('click', '.remove-gallery', function() {

            var userURL = $(this).data('url');
            var trObj = $(this);

            if (confirm("Are you sure you want to delete this banner?") == true) {
                $.ajax({
                    url: userURL,
                    type: 'DELETE',
                    dataType: 'json',
                    success: function(data) {
//                        alert(data.success);
                        trObj.closest(".thumb-preview-gallery").remove();
                    }
                });
            }
        });
        $(document).on('click', '.remove-location', function() {

            var p_id = $(this).data('id');
            var location = $(this).data('val');
            var trObj = $(this);

            if (confirm("Are you sure you want to delete this location?") == true) {
                $.ajax({
                    url: "<?php echo route('property.locationdelete') ?>",
                    type: 'PATCH',
                    data:{
                      'location': location,
                      'p_id': p_id
                    },
                    dataType: 'json',
                    success: function(data) {
//                        alert(data.success);
                        trObj.closest(".location-box").remove();
                    }
                });
            }
        });
        
       

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/property/edit.blade.php ENDPATH**/ ?>