<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Cities</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Cities</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Manage Cities</h3>
            <div class="card-tools">
                <a href="<?php echo e(route('cities.create')); ?>" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> Add New City
                </a>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if(session('success')): ?>
                <div class="alert alert-success" role="alert"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger" role="alert"><?php echo e(session('error')); ?></div>
            <?php endif; ?>
            
            <table class="table table-striped projects">
                <thead>
                    <tr>
                        <th style="width: 5%">ID</th>
                        <th style="width: 25%">Title</th>
                        <th style="width: 25%">Slug</th>
                        <th style="width: 15%">Status</th>
                        <th style="width: 15%">Properties Count</th>
                        <th style="width: 15%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($city->id); ?></td>
                        <td><?php echo e($city->title); ?></td>
                        <td><?php echo e($city->slug); ?></td>
                        <td>
                            <?php if($city->status): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($city->properties->count()); ?></td>
                        <td class="project-actions text-right">
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('cities.show', $city->id)); ?>">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <a class="btn btn-info btn-sm" href="<?php echo e(route('cities.edit', $city->id)); ?>">
                                <i class="fas fa-pencil-alt"></i> Edit
                            </a>
                            <form class="d-inline-block" action="<?php echo e(route('cities.destroy', $city->id)); ?>" method="POST" 
                                  onsubmit="return confirm('Are you sure you want to delete this city?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-center" colspan="6">No cities found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="card-footer clearfix">
            <div class="row">
                <div class="col-sm-12 col-md-5">
                    <div class="dataTables_info" role="status" aria-live="polite">
                        Showing <?php echo e($cities->firstItem() ?? 0); ?> to <?php echo e($cities->lastItem() ?? 0); ?> of <?php echo e($cities->total()); ?> results
                    </div>
                </div>
                <div class="col-sm-12 col-md-7">
                    <div class="dataTables_paginate paging_simple_numbers float-right">
                        <?php echo e($cities->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/cities/index.blade.php ENDPATH**/ ?>