<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Developer Details</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('developers.index')); ?>">Developers</a></li>
                    <li class="breadcrumb-item active"><?php echo e($developer->name); ?></li>
                </ol>
            </div>
        </div>
    </div>
</div>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e($developer->name); ?></h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('developers.edit', $developer)); ?>" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <?php if($developer->description): ?>
                                    <p><strong>Description:</strong></p>
                                    <p><?php echo e($developer->description); ?></p>
                                <?php endif; ?>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <p><strong>Location:</strong> <?php echo e($developer->location); ?></p>
                                        <p><strong>Rating:</strong> <?php echo e($developer->rating); ?> (<?php echo $developer->star_rating; ?>)</p>
                                        <p><strong>Projects Count:</strong> <?php echo e($developer->projects_count); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <?php if($developer->website_url): ?>
                                            <p><strong>Website:</strong> <a href="<?php echo e($developer->website_url); ?>" target="_blank"><?php echo e($developer->website_url); ?></a></p>
                                        <?php endif; ?>
                                        <?php if($developer->phone): ?>
                                            <p><strong>Phone:</strong> <?php echo e($developer->phone); ?></p>
                                        <?php endif; ?>
                                        <?php if($developer->email): ?>
                                            <p><strong>Email:</strong> <a href="mailto:<?php echo e($developer->email); ?>"><?php echo e($developer->email); ?></a></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <p><strong>Sort Order:</strong> <?php echo e($developer->sort_order); ?></p>
                                <p><strong>Status:</strong> 
                                    <?php if($developer->status): ?>
                                        <span class="badge badge-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Inactive</span>
                                    <?php endif; ?>
                                </p>
                                <p><strong>Slug:</strong> <?php echo e($developer->slug); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <?php if($developer->logo_url): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Logo</h3>
                        </div>
                        <div class="card-body text-center">
                            <img src="<?php echo e($developer->logo_url); ?>" alt="<?php echo e($developer->name); ?>" 
                                 class="img-fluid" style="max-height: 200px;">
                        </div>
                    </div>
                <?php endif; ?>
                
                <?php if($developer->meta_title || $developer->meta_description || $developer->meta_keywords): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">SEO Information</h3>
                        </div>
                        <div class="card-body">
                            <?php if($developer->meta_title): ?>
                                <p><strong>Meta Title:</strong><br><?php echo e($developer->meta_title); ?></p>
                            <?php endif; ?>
                            <?php if($developer->meta_description): ?>
                                <p><strong>Meta Description:</strong><br><?php echo e($developer->meta_description); ?></p>
                            <?php endif; ?>
                            <?php if($developer->meta_keywords): ?>
                                <p><strong>Meta Keywords:</strong><br><?php echo e($developer->meta_keywords); ?></p>
                            <?php endif; ?>
                            <?php if($developer->og_title): ?>
                                <p><strong>OG Title:</strong><br><?php echo e($developer->og_title); ?></p>
                            <?php endif; ?>
                            <?php if($developer->og_description): ?>
                                <p><strong>OG Description:</strong><br><?php echo e($developer->og_description); ?></p>
                            <?php endif; ?>
                            <?php if($developer->og_image): ?>
                                <p><strong>OG Image:</strong><br><a href="<?php echo e($developer->og_image); ?>" target="_blank"><?php echo e($developer->og_image); ?></a></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <a href="<?php echo e(route('developers.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to List
                </a>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/developers/show.blade.php ENDPATH**/ ?>