<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Website Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Website Configuration</h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('settings.initialize')); ?>" class="btn btn-info btn-sm">
                                <i class="fas fa-sync"></i> Initialize Default Settings
                            </a>
                        </div>
                    </div>

                    <div class="card-body">
                        <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('settings.update')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <?php if($settings->isNotEmpty()): ?>
                            <!-- Settings Tabs -->
                            <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupSettings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item">
                                    <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" 
                                       id="<?php echo e($group); ?>-tab" 
                                       data-toggle="tab" 
                                       href="#<?php echo e($group); ?>" 
                                       role="tab" 
                                       aria-controls="<?php echo e($group); ?>" 
                                       aria-selected="<?php echo e($loop->first ? 'true' : 'false'); ?>">
                                        <?php echo e(ucfirst($group)); ?>

                                    </a>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>

                            <div class="tab-content mt-3" id="settingsTabContent">
                                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupSettings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>" 
                                     id="<?php echo e($group); ?>" 
                                     role="tabpanel" 
                                     aria-labelledby="<?php echo e($group); ?>-tab">

                                    <div class="row">
                                        <?php $__currentLoopData = $groupSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6 mb-4">
                                            <div class="form-group">
                                                <label for="<?php echo e($setting->key); ?>" class="form-label">
                                                    <?php echo e($setting->label); ?>

                                                    <?php if($setting->description): ?>
                                                    <i class="fas fa-info-circle text-muted" 
                                                       data-toggle="tooltip" 
                                                       title="<?php echo e($setting->description); ?>"></i>
                                                    <?php endif; ?>
                                                </label>

                                                <?php if($setting->type === 'textarea'): ?>
                                                <textarea name="settings[<?php echo e($setting->key); ?>]" 
                                                          id="<?php echo e($setting->key); ?>" 
                                                          class="form-control" 
                                                          rows="3"><?php echo e(old("settings.{$setting->key}", $setting->value)); ?></textarea>

                                                <?php elseif($setting->type === 'image'): ?>
                                                <?php if($setting->value): ?>
                                                <div class="mb-2">
                                                    <?php if(str_starts_with($setting->value, 'settings/')): ?>
                                                    <img src="<?php echo e(asset('storage/' . $setting->value)); ?>" 
                                                         alt="<?php echo e($setting->label); ?>" 
                                                         class="img-thumbnail" 
                                                         style="max-width: 200px; max-height: 100px;">
                                                    <?php else: ?>
                                                    <img src="<?php echo e(asset($setting->value)); ?>" 
                                                         alt="<?php echo e($setting->label); ?>" 
                                                         class="img-thumbnail" 
                                                         style="max-width: 200px; max-height: 100px;">
                                                    <?php endif; ?>
                                                </div>
                                                <?php endif; ?>
                                                <input type="file" 
                                                       name="settings[<?php echo e($setting->key); ?>]" 
                                                       id="<?php echo e($setting->key); ?>" 
                                                       class="form-control" 
                                                       accept="image/*">
                                                <small class="form-text text-muted">Leave empty to keep current image</small>

                                                <?php else: ?>
                                                <input type="<?php echo e($setting->type === 'url' ? 'url' : ($setting->type === 'email' ? 'email' : 'text')); ?>" 
                                                       name="settings[<?php echo e($setting->key); ?>]" 
                                                       id="<?php echo e($setting->key); ?>" 
                                                       class="form-control" 
                                                       value="<?php echo e(old("settings.{$setting->key}", $setting->value)); ?>">
                                                <?php endif; ?>

                                                <?php if($setting->description): ?>
                                                <small class="form-text text-muted"><?php echo e($setting->description); ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Save Settings
                                </button>
                                <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                                </a>
                            </div>
                            <?php else: ?>
                            <div class="text-center py-5">
                                <p class="text-muted">No settings found. Click the button below to initialize default settings.</p>
                                <a href="<?php echo e(route('settings.initialize')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Initialize Default Settings
                                </a>
                            </div>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
  $(document).ready(function () {
      // Initialize tooltips
      $('[data-toggle="tooltip"]').tooltip();

      // Auto-hide alerts after 5 seconds
      setTimeout(function () {
          $('.alert').fadeOut('slow');
      }, 5000);

      // Initialize tabs
      $('#settingsTabs a').on('click', function (e) {
          e.preventDefault();
          $(this).tab('show');
      });
  });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/settings/index.blade.php ENDPATH**/ ?>