<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Enquiries</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Enquiries</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Enquiries</h3>

            <div class="card-tools">
                <a href="<?php echo e(route('enquiries.export')); ?>" class="btn btn-success btn-sm mr-2" title="Download Excel">
                    <i class="fas fa-download"></i> Download Excel
                </a>
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if(session('success')): ?>
            <div class="alert alert-success" role="alert"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <table class="table table-striped projects">
                <thead>
                    <tr>
                        <th style="width: 5%">
                            Sr No.
                        </th>
                        <th style="width: 20%">
                            Project URL
                        </th>
                        <th style="width: 20%">
                            User Name
                        </th>
                        <th style="width: 20%">
                            User Mobile
                        </th>
                        <th style="width: 30%">
                            User Email
                        </th>
                        <th style="width: 25%">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $enq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php echo e($enq->id); ?>

                        </td>
                        <td>
                            <a target="_blank" href="<?php echo e($enq->property_url); ?>">
                                <?php echo e($enq->property_url); ?>

                            </a>
                        </td>
                        <td>
                            <?php echo e($enq->name); ?>

                        </td>
                        <td>
                            <?php echo e($enq->mobile); ?>

                        </td>
                        <td>
                            <?php echo e($enq->email); ?>

                        </td>
                        <td class="project-actions text-right">
                            <form class="d-inline-block" action="<?php echo e(route('enquiries.destroy',$enq->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash-alt"></i>
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-center" colspan="6">There are no data available.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
        
        <!-- Pagination -->
        <div class="card-footer clearfix">
            <div class="row">
                <div class="col-sm-12 col-md-5">
                    <div class="dataTables_info" role="status" aria-live="polite">
                        Showing <?php echo e($enquiries->firstItem()); ?> to <?php echo e($enquiries->lastItem()); ?> of <?php echo e($enquiries->total()); ?> results
                    </div>
                </div>
                <div class="col-sm-12 col-md-7">
                    <div class="dataTables_paginate paging_simple_numbers float-right">
                        <?php echo e($enquiries->links()); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- /.card-footer -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/enquiries/index.blade.php ENDPATH**/ ?>