<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Developers Management</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Developers</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Developers Management</h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('developers.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add New Developer
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Logo</th>
                                    <th>Name</th>
                                    <th>Location</th>
                                    <th>Rating</th>
                                    <th>Projects</th>
                                    <th>Sort Order</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $developers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $developer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($developer->id); ?></td>
                                        <td>
                                            <?php if($developer->logo_url): ?>
                                                <img src="<?php echo e($developer->logo_url); ?>" alt="<?php echo e($developer->name); ?>" 
                                                     class="img-thumbnail" style="max-width: 50px; max-height: 50px;">
                                            <?php else: ?>
                                                <span class="badge badge-secondary">No Logo</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <strong><?php echo e($developer->name); ?></strong>
                                            <?php if($developer->website_url): ?>
                                                <br><small><a href="<?php echo e($developer->website_url); ?>" target="_blank" class="text-muted"><?php echo e($developer->website_url); ?></a></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($developer->location); ?></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="mr-2"><?php echo e($developer->rating); ?></span>
                                                <div><?php echo $developer->star_rating; ?></div>
                                            </div>
                                        </td>
                                        <td><?php echo e($developer->projects_count); ?></td>
                                        <td><?php echo e($developer->sort_order); ?></td>
                                        <td>
                                            <?php if($developer->status): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="<?php echo e(route('developers.show', $developer)); ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('developers.edit', $developer)); ?>" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('developers.destroy', $developer)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" 
                                                            onclick="return confirm('Are you sure you want to delete this developer?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">No developers found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <?php if($developers->hasPages()): ?>
                        <div class="card-footer clearfix">
                            <?php echo e($developers->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/25downtown.mwsserver.co.in/resources/views/backend/developers/index.blade.php ENDPATH**/ ?>