<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Projects</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Properties</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Properties</h3>

            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if(session('success')): ?>
            <div class="alert alert-success" role="alert"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <table class="table table-striped projects">
                <thead>
                    <tr>
                        <th style="width: 5%">
                            Sr No.
                        </th>
                        <th style="width: 20%">
                            Project Name
                        </th>
                        <th style="width: 20%">
                            Project Image
                        </th>
                        <th style="width: 30%">
                            Project Location
                        </th>
                        <th>
                            Project Price
                        </th>
                        <th style="width: 8%" class="text-center">
                            Status
                        </th>
                        <th style="width: 25%">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php echo e($property->id); ?>

                        </td>
                        <td>
                            <a target="_blank" href="<?php echo e(route('frontend.property.details', ['slug' => $property->property_slug])); ?>">
                                <?php echo e($property->property_title); ?>

                            </a>
                        </td>
                        <td>
                            <?php if(isset($property->property_logo)): ?>
                            <span>
                                <small> | <a href="<?php echo e(Storage::url($property->property_logo)); ?>">File</a></small>
                            </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($property->property_location); ?>

                        </td>
                        <td class="project_progress">
                            <small>
                                <?php echo e($property->property_price); ?>

                            </small>
                        </td>
                        <td class="project-state">
                            <?php echo e($property->status == 1 ? "Active" : "Inactive"); ?>

                        </td>
                        <td class="project-actions text-right">
                            <!--                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('property.show', $property->id)); ?>">
                                                            <i class="fas fa-folder">
                                                            </i>
                                                            View
                                                        </a>-->
                            <a class="btn btn-info btn-sm" href="<?php echo e(route('property.edit', $property->id)); ?>">
                                <i class="fas fa-pencil-alt">
                                </i>
                                Edit
                            </a>
                            <form class="d-inline-block" action="<?php echo e(route('property.destroy',$property->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash-alt"></i>
                                    <?php echo e(__('Delete')); ?>

                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4">There are no data.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/property/resources/views/backend/property/index.blade.php ENDPATH**/ ?>