<?php include 'header_css_js.php'; ?>
<?php
$limit = 100;
$sql = "SELECT count(*) as count FROM cities WHERE 1 ";
$db =  new Database();
$db->query($sql);
$cities = $db->single();
$city_count = $cities['count'];
if ($city_count > 0) {
    $page_num = isset($_GET['pagenum']) ? $_GET['pagenum'] : 1;
    $startAt = $limit * ($page_num - 1);
    $sql = "SELECT *,(SELECT cun_name FROM countries WHERE cun_id = cit_country_id) as country_name,(SELECT sts_name FROM states WHERE sts_id = cit_state_id) as state_name FROM cities WHERE 1 AND cit_country_id = 101 LIMIT " .  $startAt . ',' . $limit;
    $db =  new Database();
    $db->query($sql);
    $cities = $db->getAll();
    $cities_pagination  = new Pagination($city_count, $page_num, $limit);
}
?>

<body>
    <?php include 'preloader.php'; ?>
    <div id="main-wrapper">
        <?php include 'header_burger_button.php'; ?>
        <?php include 'header_navigation.php'; ?>
        <?php include 'sidebar.php'; ?>
        <div class="content-body">
            <div class="container-fluid">
                <div class="page-titles">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Location</a></li>
                        <li class="breadcrumb-item active"><a href="javascript:void(0)">City List</a></li>
                    </ol>
                </div>
                <!-- row -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">City List</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="display table" style="min-width: 850px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>City Name</th>
                                                <th>State Name</th>
                                                <th>Country Name</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($city_count > 0) {
                                                foreach ($cities as $pk => $row) {
                                            ?>
                                                    <tr>
                                                        <td><?= ++$pk; ?></td>
                                                        <td><?php echo $row['cit_name']; ?></td>
                                                        <td><?php echo $row['state_name']; ?></td>
                                                        <td><?php echo $row['country_name']; ?></td>
                                                        <td><?php echo ($row['cit_status'] == 1) ? 'Active' : 'Inactive'; ?></td>
                                                    </tr>
                                                <?php
                                                }
                                            } else { ?>
                                                <tr>
                                                    <td colspan="5" class="text-center">No Records Found</td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php if ($city_count > 0) { ?>
                                    <div class="col-lg-12">
                                        <p class="mb-2 me-3"></p>
                                        <?= $cities_pagination->displayAdminLinks(ADMIN_URL . 'cities'); ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'copyright.php'; ?>
    </div>
    <?php include 'footer_js.php'; ?>
</body>

</html>