<?php
session_start();

defined('ENVIRONMENT') || define('ENVIRONMENT', 'prod');
if (ENVIRONMENT == 'prod') {
	defined('SITE_URL') || define('SITE_URL', 'https://akhand.mwsserver.co.in/');
	defined('USER_NAME') || define('USER_NAME', 'mwsserverco_property_booking');
	defined('PASSWORD') || define('PASSWORD', 'mwsserverco_property_booking');
} else {
	defined('SITE_URL') || define('SITE_URL', 'http://localhost/akhand.mwsserver.co.in/');
	defined('USER_NAME') || define('USER_NAME', 'root');
	defined('PASSWORD') || define('PASSWORD', '');
}

defined('HOST_NAME') || define('HOST_NAME', 'localhost');

defined('DATABASE') || define('DATABASE', 'mwsserverco_property_booking');
defined('ADMIN_URL') || define('ADMIN_URL', SITE_URL . 'admin/');
defined('STATUS') || define('STATUS', ['0' => 'Inactive', '1' => 'Active']);
defined('MAILER_TO_ADDRESS') || define('MAILER_TO_ADDRESS','crm.salesoffice@gmail.com');
defined('MAILER_TO_NAME') || define('MAILER_TO_NAME','akhand');
defined('BHK_MIN_PRICES') || define('BHK_MIN_PRICES', [
	'200000'  => 'Min',
	'500000'  => '₹ 5 Lac',
	'1000000'  => '₹ 10 Lac',
	'1500000'  => '₹ 15 Lac',
	'2000000'  => '₹ 20 Lac',
	'2500000'  => '₹ 25 Lac',
	'3000000'  => '₹ 30 Lac',
	'3500000'  => '₹ 35 Lac',
	'4000000'  => '₹ 40 Lac',
	'4500000'  => '₹ 45 Lac',
	'5000000'  => '₹ 50 Lac',
	'5500000'  => '₹ 55 Lac',
	'6000000'  => '₹ 60 Lac',
	'6500000'  => '₹ 65 Lac',
	'7000000'  => '₹ 70 Lac',
	'7500000'  => '₹ 75 Lac',
	'8000000'  => '₹ 80 Lac',
	'8500000'  => '₹ 85 Lac',
	'9000000'  => '₹ 90 Lac',
	'9500000'  => '₹ 95 Lac',
	'10000000'  => '₹ 1 Cr',
	'12000000'  => '₹ 1.2 Cr',
	'14000000'  => '₹ 1.4 Cr',
	'16000000'  => '₹ 1.6 Cr',
	'18000000'  => '₹ 1.8 Cr',
	'20000000'  => '₹ 2 Cr',
	'22000000'  => '₹ 2.2 Cr',
	'24000000'  => '₹ 2.4 Cr',
	'28000000'  => '₹ 2.8 Cr',
	'30000000'  => '₹ 3 Cr',
	'32000000'  => '₹ 3.2 Cr',
	'34000000'  => '₹ 3.4 Cr',
	'36000000'  => '₹ 3.6 Cr',
	'37000000'  => '₹ 3.7 Cr',
	'38000000'  => '₹ 3.8 Cr',
	'40000000'  => '₹ 4 Cr',
	'45000000'  => '₹ 4.5 Cr',
	'50000000'  => '₹ 5 Cr',
	'48000000'  => '₹ 10 Cr',
]);

defined('BHK_MAX_PRICES') || define('BHK_MAX_PRICES', [
	'500000'  => '₹ 5 Lac',
	'1000000'  => '₹ 10 Lac',
	'1500000'  => '₹ 15 Lac',
	'2000000'  => '₹ 20 Lac',
	'2500000'  => '₹ 25 Lac',
	'3000000'  => '₹ 30 Lac',
	'3500000'  => '₹ 35 Lac',
	'4000000'  => '₹ 40 Lac',
	'4500000'  => '₹ 45 Lac',
	'5000000'  => '₹ 50 Lac',
	'5500000'  => '₹ 55 Lac',
	'6000000'  => '₹ 60 Lac',
	'6500000'  => '₹ 65 Lac',
	'7000000'  => '₹ 70 Lac',
	'7500000'  => '₹ 75 Lac',
	'8000000'  => '₹ 80 Lac',
	'8500000'  => '₹ 85 Lac',
	'9000000'  => '₹ 90 Lac',
	'9500000'  => '₹ 95 Lac',
	'10000000'  => '₹ 1 Cr',
	'12000000'  => '₹ 1.2 Cr',
	'14000000'  => '₹ 1.4 Cr',
	'16000000'  => '₹ 1.6 Cr',
	'18000000'  => '₹ 1.8 Cr',
	'20000000'  => '₹ 2 Cr',
	'22000000'  => '₹ 2.2 Cr',
	'24000000'  => '₹ 2.4 Cr',
	'28000000'  => '₹ 2.8 Cr',
	'30000000'  => '₹ 3 Cr',
	'32000000'  => '₹ 3.2 Cr',
	'34000000'  => '₹ 3.4 Cr',
	'36000000'  => '₹ 3.6 Cr',
	'37000000'  => '₹ 3.7 Cr',
	'38000000'  => '₹ 3.8 Cr',
	'40000000'  => '₹ 4 Cr',
	'45000000'  => '₹ 4.5 Cr',
	'50000000'  => '₹ 5 Cr',
	'48000000'  => '₹ 10 Cr',
	'200000000'  => 'Max'
]);

defined('BHK_DOWN_PAYMENTS') || define('BHK_DOWN_PAYMENTS', [
	'200000' => 'Max',
	'500000' => '₹ 5 Lac',
	'1000000' => '₹ 10 Lac',
	'1500000' => '₹ 15 Lac',
	'2000000' => '₹ 20 Lac',
	'2500000' => '₹ 25 Lac',
	'3000000' => '₹ 30 Lac',
	'3500000' => '₹ 35 Lac',
	'4000000' => '₹ 40 Lac',
	'4500000' => '₹ 45 Lac',
	'5000000' => '₹ 50 Lac'
]);


defined('BHK_POSSESSIONS') || define('BHK_POSSESSIONS', [
	'new' => 'New Launch (3Yrs or more)',
	'ready' => 'Ready To Move',
	'less' => 'Advanced Stage (within 3-6months)',
	'medium' => 'Mid Stage (1-1.5yrs)',
	'later' => 'Early Stage (2-3yrs)',
	'max' => 'Less than 1 Year'
]);


defined('TOP_LOCALITY') || define('TOP_LOCALITY', [133504 => 'Pune', 133024 => 'Mumbai', 134138 => 'Thane', 57848 => 'Bangalore', 57606 => 'Ahmadabad', 132132 => 'Hyderabad', 133116 => 'Nagpur']);

defined('BHK_SCHEMES') || define('BHK_SCHEMES', [
	'clp' => 'Construction Link Plan (CLP)',
	'builder_subvention' => 'Builder Subvention',
	'subvention_scheme' => 'Subvention Scheme',
	'bank_subvention' => 'Bank Subvention',
	'max' => 'Rs4999 / Month - 2years',
	'flexi_payment_scheme' => 'Flexi Payment Scheme'
]);

defined('SORT_FILTER') || define('SORT_FILTER', [
	// 'tp' => 'Top Projects',
	'l_t_h' => 'Low To High',
	'h_t_l' => 'High to Low'
]);

defined('APPOINTMENT_MODE') || define('APPOINTMENT_MODE', ['ola' => 'OLA', 'zoom' => 'Zoom', 'g_meet' => 'Google Meet', 'team' => 'MS Team']);

function redirect($url)
{
	echo '<script> window.location.href="' . $url . '"; </script>';
	exit;
}

function debug($data, $die = true)
{
	echo '<pre>';
	print_r($data);
	echo '</pre>';
	if ($die == true) {
		die;
	}
}


// connect to database
include 'db.php';

include 'pagination.php';

// variable declaration
$errors   = array();

// call the register() function if register_btn is clicked
if (isset($_POST['register_btn'])) {
	register();
}


// call the login() function if register_btn is clicked
if (isset($_POST['login_btn'])) {
	login();
}


if (isset($_GET['logout'])) {
	if (isAdmin()) {
		$url = ADMIN_URL;
	} else {
		$url = SITE_URL;
	}
	session_destroy();
	unset($_SESSION['user']);
	redirect($url);
}


// REGISTER USER
function register()
{
	global $errors;
	// receive all input values from the form
	$username    =  $_POST['username'];
	$email       =  $_POST['email'];
	$password_1  =  $_POST['password_1'];
	$password_2  =  $_POST['password_2'];
	// form validation: ensure that the form is correctly filled
	if (empty($username)) {
		array_push($errors, "Username is required");
	}
	if (empty($email)) {
		array_push($errors, "Email is required");
	}
	if (empty($password_1)) {
		array_push($errors, "Password is required");
	}
	if ($password_1 != $password_2) {
		array_push($errors, "The two passwords do not match");
	}
	// register user if there are no errors in the form
	if (count($errors) == 0) {
		$password = md5($password_1);
		//encrypt the password before saving in the database
		if (isset($_POST['user_type'])) {
			$user_type = $_POST['user_type'];
			$url = ADMIN_URL;
		} else {
			$user_type = 'user';
			$url = SITE_URL;
		}
		$sql = "INSERT INTO users (username, email, user_type, password)
		VALUES(:username, :email, :user_type, :pwd)";
		$db =  new Database();
		$db->beginTransaction();
		$db->query($sql);
		$db->bind(':username', $username);
		$db->bind(':email', $email);
		$db->bind(':user_type', $user_type);
		$db->bind(':pwd', $password);
		$result = $db->execute();
		if ($result) {
			$last_insert_id = $db->lastInsertId();
			$db->commit();
			$logged_in_user_id = $last_insert_id;
			$_SESSION['user'] = getUserById($logged_in_user_id); // put logged in user in session
			$_SESSION['success']  = "New user successfully created! You are now logged in!";
		} else {
			$db->rollBack();
		}
		redirect(SITE_URL . $url);
	} else {
		redirect(SITE_URL);
	}
}


// return user array from their id
function getUserById($id)
{
	if ($id > 0) {
		$sql = "SELECT * FROM users WHERE id=" . $id;
		$db =  new Database();
		$db->query($sql);
		$user = $db->single();
		return $user;
	} else {
		return [];
	}
}


// LOGIN USER
function login()
{
	global $errors;
	// grap form values
	$username = $_POST['username'];
	$password = $_POST['password'];
	// make sure form is filled properly
	if (empty($username)) {
		array_push($errors, "Username is required");
	}
	if (empty($password)) {
		array_push($errors, "Password is required");
	}
	// attempt login if no errors on form
	if (count($errors) == 0) {
		$password = md5($password);
		$sql = "SELECT * FROM users WHERE username='$username' AND password='$password' LIMIT 1";
		$db =  new Database();
		$db->query($sql);
		$results = $db->single();
		if ($results) { // user found
			// check if user is admin or user
			$logged_in_user = $results;
			if ($logged_in_user['user_type'] == 'admin') {
				$_SESSION['user'] = $logged_in_user;
				$_SESSION['success']  = "You are now logged in";
				redirect(ADMIN_URL);
			} else {
				$_SESSION['user'] = $logged_in_user;
				$_SESSION['success']  = "You are now logged in";
				redirect(SITE_URL);
			}
		} else {
			array_push($errors, "Wrong username/password combination");
		}
	}
}


function isLoggedIn()
{
	if (isset($_SESSION['user'])) {
		return true;
	} else {
		return false;
	}
}


function isAdmin()
{
	if (isset($_SESSION['user']) && $_SESSION['user']['user_type'] == 'admin') {
		return true;
	} else {
		return false;
	}
}


function display_error()
{
	global $errors;
	if (count($errors) > 0) {
		echo '<div class="alert alert-danger alert-dismissible fade show">
			<strong>Error!</strong><div class="error"><button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>';
		foreach ($errors as $error) {
			echo $error . '<br>';
		}
		echo '</div>';
	}
}


function display_messages()
{
	if (isset($_SESSION['message'])) {
		echo '<div class="alert alert-' . ($_SESSION['message']['type'] == 'error' ? 'danger' : 'success') . ' alert-dismissible fade show">
			<strong>' . ($_SESSION['message']['type'] == 'error' ? 'Error' : 'Success') . '!</strong><div class="error"><button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>';
		echo $_SESSION['message']['msg'];
		echo '</div>';
		unset($_SESSION['message']);
	}
}


function checkAdminLogin()
{
	if (!isAdmin()) {
		$_SESSION['msg'] = "You must log in first";
		redirect(SITE_URL);
	}
}





function checkAdminLoggedIn()
{
	if (isAdmin()) {
		redirect(ADMIN_URL);
	}
}
