<!doctype html>
<html class="no-js" <?php language_attributes(); ?> <?php blankslate_schema_type(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <title>Collabrixtech</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- Place favicon.ico in the root directory -->
        <link rel="shortcut icon" type="image/x-icon" href="<?= get_template_directory_uri(); ?>/assets/img/favicon.png">
        <!-- CSS here -->
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/preloader.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/meanmenu.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/animate.min.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/swiper-bundle.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/backToTop.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/magnific-popup.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/nice-select.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/fontAwesome5Pro.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/flaticon.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/default.css">
        <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/assets/css/style.css">
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>

        <?php wp_body_open(); ?>
        <!--[if lte IE 9]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
<![endif]-->

        <!-- Add your site or application content here -->

        <!-- pre loader area start -->
        <div id="loading">
            <div id="loading-center">
                <div id="loading-center-absolute">
                    <div class="object" id="object_one"></div>
                    <div class="object" id="object_two" ></div>
                    <div class="object" id="object_three"></div>
                    <div class="object" id="object_four"></div>
                    <div class="object" id="object_five"></div>
                </div>
            </div>
        </div>
        <!-- pre loader area end -->

        <!-- back to top start -->
        <div class="progress-wrap">
            <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
            </svg>
        </div>
        <!-- back to top end -->

        <!-- header area start -->
        <header>
            <div class="header__area header__transparent header__padding">
                <div class="header__top header__top-6 d-none d-lg-block">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-xxl-8 col-xl-8 col-lg-8">
                                <div class="header__info header__info-6">
                                    <ul>
                                        <li>
                                            <a target="_blank" href="https://www.google.com/maps/place/Dhaka/@23.7806207,90.3492859,12z/data=!3m1!4b1!4m5!3m4!1s0x3755b8b087026b81:0x8fa563bbdd5904c2!8m2!3d23.8104753!4d90.4119873">
                                                <i class="flaticon-maps-and-flags"></i>
                                                Easter House, New York, USA
                                            </a>
                                        </li>
                                        <li>
                                            <a href="mailto:info@example.com">
                                                <i class="flaticon-mail-inbox-app"></i>
                                                info@exmaple.com
                                            </a>
                                        </li>
                                        <li>
                                            <a href="tel:+1-555-451-7-0890">
                                                <i class="flaticon-phone"></i>
                                                +1 (555) 451 7 0890
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xxl-4 col-xl-4 col-lg-4">
                                <div class="header__top-right text-rubik-all d-flex align-items-center justify-content-end">
                                    <div class="header__lang d-flex align-items-center">
                                        <img class="translate-img" src="<?= get_template_directory_uri(); ?>/assets/img/icon/translate.png" alt="">
                                        <select>
                                            <option>English</option>
                                            <option>English</option>
                                            <option>English</option>
                                            <option>English</option>
                                        </select>
                                    </div>
                                    <div class="header__login pl-25 ml-25">
                                        <span>
                                            <a href="#">Login / </a>
                                            <a href="#">Register</a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="header-sticky" class="header__bottom header__sticky">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
                                <!-- logo start -->
                                <div class="logo">
                                    <a href="/">
                                        <h1 style="color: #fff;font-size: 2em" class="text-popins">Collabrixtech</h1>
                                        <!--<img src="<?= get_template_directory_uri(); ?>/assets/img/logo/logo-6.png" alt="logo">-->
                                    </a>
                                </div>
                                <!-- logo end -->
                            </div>
                            <div class="col-xxl-10 col-xl-9 col-lg-9 col-md-6 col-sm-6 col-6">
                                <div class="header__bottom-right d-flex align-items-center justify-content-end">
                                    <div class="main-menu main-menu-6 mr-40">
                                        <nav id="mobile-menu">
                                            <ul>
                                                <li>
                                                    <a href="/">Home</a>
                                                </li>
                                                <li>
                                                    <a href="about">Who we are</a>
                                                </li>
                                                <li>
                                                    <a href="services">Our Service <i class="fal fa-plus"></i></a>
                                                    <ul class="submenu">
                                                        <li>
                                                            <a href="services.html">Content Trust & Safety</a>
                                                        </li>
                                                        <li>
                                                            <a href="services-details.html">CX Management</a>
                                                        </li>
                                                        <li>
                                                            <a href="services-details.html">Data & Analytics</a>
                                                        </li>
                                                        <li>
                                                            <a href="services-details.html">Proctoring Services</a>
                                                        </li>
                                                        <li>
                                                            <a href="services-details.html">Telecalling/Voice Support or Non Voice</a>
                                                        </li>
                                                        <li>
                                                            <a href="services-details.html">Data Annotation & Data Labelling</a>
                                                        </li>
                                                    </ul>
                                                </li>
<!--                                                <li>
                                                    <a href="about.html">How we work our process</a>
                                                </li>-->
                                                <li>
                                                    <a href="about.html">Why Collabrix</a>
                                                </li>
                                                <li>
                                                    <a href="contact">Contact</a>
                                                </li>
                                                <li>
                                                    <a href="careers">Careers</a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                    <div class="header__action header__action-6">
                                        <ul>
                                            <li>
                                                <a href="javascript:void(0)" class="search-toggle">
                                                    <i class="flaticon-search"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0)" class="offcanvas-toggle-btn">
                                                    <i class="flaticon-menu"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="header__call-6 d-none d-xxl-flex align-items-center ml-40">
                                        <div class="header__call-icon-6 mr-10">
                                            <img src="<?= get_template_directory_uri(); ?>/assets/img/icon/chatting.png" alt="">
                                        </div>
                                        <div class="header__call-content-6">
                                            <p class="text-rubik">Contact for support</p>
                                            <h3 class="text-rubik"><a href="tel:+1-890-873-187">+1 890 873 187</a></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- header area end -->

        <!-- offcanvas area start -->
        <div class="offcanvas__area">
            <div class="offcanvas__wrapper">
                <div class="offcanvas__close">
                    <button class="offcanvas__close-btn" id="offcanvas__close-btn">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <div class="offcanvas__content">
                    <div class="offcanvas__logo mb-40">
                        <a href="index.html">
                            <img src="<?= get_template_directory_uri(); ?>/assets/img/logo/logo-black.png" alt="logo">
                        </a>
                    </div>
                    <div class="offcanvas__search mb-25">
                        <form action="#">
                            <input type="text" placeholder="What are you searching for?">
                            <button type="submit" ><i class="far fa-search"></i></button>
                        </form>
                    </div>
                    <div class="mobile-menu fix"></div>
                    <div class="offcanvas__text d-none d-lg-block">
                        <p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and will give you a complete account of the system and expound the actual teachings of the great explore</p>
                    </div>
                    <div class="offcanvas__img d-none d-lg-block mb-20">
                        <div class="row gx-2">
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-1.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-1.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-2.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-2.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-3.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-3.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-4.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-4.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-5.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-5.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="offcanvas__single-img w-img mb-10">
                                    <a class="popup-img" href="assets/img/offcanvas/offcanvas-6.jpg">
                                        <img src="<?= get_template_directory_uri(); ?>/assets/img/offcanvas/offcanvas-6.jpg" alt="">
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="offcanvas__map d-none d-lg-block mb-15">
                        <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d29176.030811137334!2d90.3883827!3d23.924917699999998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sbd!4v1605272373598!5m2!1sen!2sbd"></iframe>
                    </div>
                    <div class="offcanvas__contact mt-30 mb-20">
                        <h4>Contact Info</h4>

                        <ul>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="fal fa-map-marker-alt"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a target="_blank" href="https://www.google.com/maps/place/Dhaka/@23.7806207,90.3492859,12z/data=!3m1!4b1!4m5!3m4!1s0x3755b8b087026b81:0x8fa563bbdd5904c2!8m2!3d23.8104753!4d90.4119873">12/A, Mirnada City Tower, NYC</a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="far fa-phone"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="mailto:support@gmail.com">088889797697</a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="fal fa-envelope"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="tel:+012-345-6789">support@mail.com</a>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="offcanvas__social">
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="#"><i class="fab fa-youtube"></i></a></li>
                            <li><a href="#"><i class="fab fa-linkedin"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- offcanvas area end -->      
        <div class="body-overlay"></div>
        <!-- offcanvas area end -->

        <!-- search overlay start -->
        <section class="search__area d-flex align-items-center">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="search__wrapper">
                            <div class="search__close">
                                <button class="search-close-btn"><i class="fal fa-times"></i></button>
                            </div>
                            <form action="#">
                                <div class="search__input">
                                    <input type="text" placeholder="Search here...">
                                    <button type="submit"><i class="far fa-search"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- search overlay end -->