<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Pages';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
$route['download/(:any)'] = "/pages/download_pdf/$1";
/**
 * Page Routes
 */
$route['/'] = 'Pages/index';
$route['admin'] = 'admin/dashboard';

$route['signout'] = 'users/signout';
$route['signin'] = 'users/signin';
$route['signup'] = 'users/signup';
$route['forgot_password'] = 'users/forgot_password';
$route['auth/activate/(:num)/(:any)'] = 'users/activate/$1/$2';

/**
 * Admin Product Routes 
 */
$route['admin/products/index'] = 'admin/products/index';
$route['admin/products/index/(:num)'] = 'admin/products/index/$1';
$route['admin/products'] = 'admin/products/index';
$route['admin/products/add'] = 'admin/products/add';
$route['admin/products/edit/(:num)'] = 'admin/products/edit/$1';
$route['admin/products/delete/(:num)'] = 'admin/products/delete/$1';

$route['admin/product-category'] = 'admin/Products_category/index';
$route['admin/product-category/index'] = 'admin/Products_category/index';
$route['admin/product-category/index/(:num)'] = 'admin/Products_category/index/$1';
$route['admin/product-category/add'] = 'admin/Products_category/add';
$route['admin/product-category/edit/(:num)'] = 'admin/Products_category/edit/$1';
$route['admin/product-category/delete/(:num)'] = 'admin/Products_category/delete/$1';

$route['admin/locations'] = 'admin/locations/index';
$route['admin/locations/index'] = 'admin/locations/index';
$route['admin/locations/index/(:num)'] = 'admin/locations/index/$1';
$route['admin/locations/add'] = 'admin/locations/add';
$route['admin/locations/edit/(:num)'] = 'admin/locations/edit/$1';
$route['admin/locations/delete/(:num)'] = 'admin/locations/delete/$1';

$route['admin/orders'] = 'admin/orders/index';
$route['admin/orders/index'] = 'admin/orders/index';
$route['admin/orders/index/(:num)'] = 'admin/orders/index/$1';
$route['admin/orders/edit/(:num)'] = 'admin/orders/edit/$1';
$route['admin/orders/delete/(:num)'] = 'admin/orders/delete/$1';

$route['admin/file-manager'] = 'admin/File_manager/index';
$route['admin/file-manager/index'] = 'admin/File_manager/index';
$route['admin/file-manager/index/(:num)'] = 'admin/File_manager/index/$1';
$route['admin/file-manager/add'] = 'admin/File_manager/add';
$route['admin/file-manager/edit/(:num)'] = 'admin/File_manager/edit/$1';
$route['admin/file-manager/delete/(:num)'] = 'admin/File_manager/delete/$1';

$route['admin/member-files'] = 'admin/Member_files/index';
$route['admin/member-files/index'] = 'admin/Member_files/index';
$route['admin/member-files/index/(:num)'] = 'admin/Member_files/index/$1';
$route['admin/member-files/add'] = 'admin/Member_files/add';
$route['admin/member-files/edit/(:num)'] = 'admin/Member_files/edit/$1';
$route['admin/member-files/delete/(:num)'] = 'admin/Member_files/delete/$1';

$route['admin/forms/career'] = 'admin/Forms/career';
$route['admin/forms/enquiry'] = 'admin/Forms/enquiries';
$route['admin/forms/career/delete/(:num)'] = 'admin/Forms/career_delete/$1';
$route['admin/forms/enquiry/delete/(:num)'] = 'admin/Forms/enquiries_delete/$1';

/**
 * Front Routes 
 */
$route['partners/login'] = 'Partners/login';
$route['partners/dashboard'] = 'Partners/dashboard';

$route['members/login'] = 'Members/login';
$route['members/dashboard'] = 'Members/dashboard';
$route['members/spare-part-list'] = 'Members/spare_part_list';
$route['members/user-manual'] = 'Members/user_manual';
$route['members/catalogue'] = 'Members/catalogue';
$route['members/logout'] = 'Members/logout';

$route['about-us'] = 'Pages/about';
$route['product'] = 'Pages/product';
$route['product-category/(:any)'] = 'Pages/productCategory/$1';

$route['career'] = 'Pages/career';
$route['support-team'] = 'Pages/support_team';
$route['enquiry'] = 'Pages/enquiry';
$route['product/enquiry/(:num)'] = 'Pages/productEnquiry/$1';
$route['news'] = 'Pages/news';

$route['read/(:any)'] = 'posts/read/$1';
$route['product/(:any)'] = 'pages/productDetail/$1';

$route['locations'] = 'Pages/locations';
$route['contact-us'] = 'Pages/contact';
