<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Members extends MY_Controller {

    function __construct()
    {
        parent::__construct();
        $this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
        $this->lang->load('auth');
        $this->load->model('User');
        $this->load->model('Group');

        $this->data['parent_menu'] = 'members';
    }

    public function login()
    {
        $data['content'] = '';
        $data['page_name'] = 'login';

        if ($this->ion_auth->logged_in() && $this->ion_auth->current_role() == 'members') {
            redirect('members/dashboard');
        }

        //validate form input
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');

        if ($this->form_validation->run() == true) {
            //check to see if the user is logging in
            //check for "remember me"
            $name = $this->input->post('name');
            $pass = $this->input->post('password');
            $email = '';
            $user_data =  $this->db->query("SELECT `email` FROM users WHERE username = '$name'")->row_array();
            
            $email = $user_data['email'];
            
            if ($this->ion_auth->login($email, $pass)) {
                //if the login is successful
                //redirect them back to the home page
                $this->session->set_flashdata('message', message_box('Successfull', 'success'));
                redirect('members/dashboard', 'refresh');
            } else {
                //if the login was un-successful
                //redirect them back to the login page
                $this->session->set_flashdata('message', message_box($this->ion_auth->errors(), 'danger'));
                redirect('members/login', 'refresh'); //use redirects instead of loading views for compatibility with MY_Controller libraries
            }
        }
        $this->renderView('Home', 'members/login', $data);
    }

    public function logout()
    {
        $this->ion_auth->logout();
        $this->session->set_flashdata('message', message_box('You have signed out successfully', 'success'));
        redirect('/', 'refresh');
    }

    public function dashboard()
    {
         if ($this->ion_auth->current_role() != 'members') {
            redirect('members/login');
        }
        $data['content'] = '';
        $data['page_name'] = 'Dashboard';

        $this->renderView('Members Admin', 'members/dashboard', $data);
    }

    public function spare_part_list()
    {
        $data['content'] = '';
        $data['page_name'] = 'Spare Part List';
        
        $data['spare_part_list'] = $this->db->get_where("member_files",array('file_group_name' => 'Spare Part List'))->result_array();
        $this->renderView('Sparepart List', 'members/sparepart_list', $data);
    }

    public function user_manual()
    {
        $data['content'] = '';
        $data['page_name'] = 'User Manual';
        
        $data['user_manuals'] = $this->db->get_where("member_files",array('file_group_name' => 'User Manual'))->result_array();
        $this->renderView('User Manual', 'members/user_manual', $data);
    }

    public function catalogue()
    {
        $data['content'] = '';
        $data['page_name'] = 'Catalogue';
        
        $data['catalogue'] = $this->db->get_where("member_files",array('file_group_name' => 'Catalogue 2016-2017'))->result_array();
        $this->renderView('Catalogue', 'members/catalogue', $data);
    }
	
	 public function combooffer()
    {
        $data['content'] = '';
        $data['page_name'] = 'combooffer';
        
        $data['catalogue'] = $this->db->get_where("member_files",array('file_group_name' => 'Catalogue 2016-2017'))->result_array();
        $this->renderView('combooffer', 'members/combooffer', $data);
    }

}
