<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php

class Pages extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Page');
        $this->load->model('Post');
        $this->load->model('Product');
        $this->load->model('Slider');
        $this->load->model('Product_category_model');
        $this->load->model('Location');
        $this->load->helper('text');
    }

    public function latestNews()
    {
        $newsData = $this->Post->find_active();
        return $newsData;
    }

    public function productDetail($slug)
    {
        $data['content'] = '';
        $data['newsData'] = $this->latestNews();
        $data['product'] = $this->Product->find_by_slug($slug);
        $data['product_thumbs'] = $this->Product->product_thumbnails($data['product']['id']);
        $data['page_name'] = $data['product']['title'];
        $this->renderView('Home', 'pages/product_details', $data);
    }

    public function index()
    {
        $data['content'] = '';
        $data['page_name'] = 'home';

        $about = $this->Page->find_by_id(2);
        $productData = $this->Product->find_latest_product();
        $locationData = $this->Location->find(4);
        $data['sliders'] = $this->Slider->find(6);
        $data['aboutData'] = $about;
        $data['newsData'] = $this->latestNews();
        $data['productData'] = $productData;
        $data['locationData'] = $locationData;
        $this->renderView('Home', 'pages/home', $data);
    }

    public function about()
    {
        $data['newsData'] = $this->latestNews();
        $data['content'] = $this->Page->find_by_slug('about-us');
        $data['page_name'] = 'about-us';
        $this->renderView('About Us', 'pages/index', $data);
    }

    public function contact()
    {
        $data['newsData'] = $this->latestNews();
        $data['content'] = $this->Page->find_by_slug('contact-us');
        $data['page_name'] = 'contact-us';
        $this->renderView('Contact Us', 'pages/contact', $data);
    }

    public function product()
    {
        $data['newsData'] = $this->latestNews();
        $data['content'] = '';
        $data['page_name'] = 'product';
        $this->renderView('Home', 'pages/product', $data);
    }

    public function productCategory($slug)
    {
        if ($slug != '') {
            $parent_cat = $this->Product_category_model->find_by_slug($slug);
            $data['page_name'] = $parent_cat['name'];
            $productData = $this->Product->find_by_category($slug);
            $data['product_cat'] = $parent_cat;
            $data['productData'] = $productData;
            $this->renderView('Products', 'pages/product_cat', $data);
        }
    }
    
    public function support_team()
    {
        $data['page_name'] = 'support-team';
         $this->renderView('Support Team', 'pages/support', $data);
    }

    public function career()
    {
//        $fileName =  'assets/uploads/HR_Profile.pdf';
//        $this->load->helper('download');
//        if ($fileName) {
//            $file = site_url() . $fileName;
//            // check file exists    
//            if (file_exists($fileName)) {
//                // get file content
//                $data = file_get_contents($file);
//                //force download
//                $new_name = str_replace('assets/uploads/', '', $fileName);
//                force_download($new_name, $data);
//            } else {
//                // Redirect to base url
//                redirect(base_url());
//            }
//        }
//        $data['newsData'] = $this->latestNews();
//        $data['content'] = '';
        $data['page_name'] = 'career';

        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('contact_no', 'Contact No', 'required|numeric|max_length[10]');
        $this->form_validation->set_rules('emailId', 'Email', 'required');
        $this->form_validation->set_rules('designation', 'Designation', 'required');
        $this->form_validation->set_rules('experience', 'Experience', 'required');
        $this->form_validation->set_rules('salary', 'Salary', 'required');
        $this->form_validation->set_rules('location', 'Location', 'required');

        if ($this->form_validation->run() == true) {

            $config['upload_path'] = $this->assets_path;
            $config['allowed_types'] = $this->Setting->findByKey('file_type');
            $config['max_size'] = $this->Setting->findByKey('file_max_size');
            $this->load->library('upload', $config);
            $cv_url = '';
            if ($_FILES['cv']['error'] != 4) {
                if (!$this->upload->do_upload('cv')) {
                    $error = array('error' => $this->upload->display_errors());
                } else {
                    $cv = $this->upload->data();
                    $cv_url = $this->assets_path . $cv['orig_name'];
                }
            }

            $name = $this->input->post('name');
            $contact_no = $this->input->post('contact_no');
            $emailId = $this->input->post('emailId');
            $designation = $this->input->post('designation');
            $experience = $this->input->post('experience');
            $salary = $this->input->post('salary');
            $location = $this->input->post('location');
            $careerData = array(
                'name' => $name,
                'contact_no' => $this->input->post('contact_no'),
                'email_id' => $this->input->post('emailId'),
                'designation' => $this->input->post('designation'),
                'experience' => $this->input->post('experience'),
                'salary' => $this->input->post('salary'),
                'location' => $this->input->post('location'),
                'cv_url' => $cv_url,
                'created_at' => date('Y-m-d H:i:s'),
            );
            
            $this->load->library('email');
            // SMTP SETUP Start
            $config = [];
            $config['protocol'] = 'smtp';
            $config['smtp_host'] = 'smtp.office365.com';
            $config['smtp_user'] = 'support@foggersindia.com';
            $config['smtp_pass'] = 'Pallavi@3333';
            $config['smtp_port'] = 587;
            $config['newline'] = "\r\n";
            $config['smtp_crypto'] = 'tls';
            $this->email->initialize($config);
            $this->email->set_crlf( "\r\n" );
            // SMTP SETUP End
            
            $this->email->from('support@foggersindia.com', 'Foggers India');
//            $this->email->from('hr@foggersindia.com', 'Foggers India');
            $this->email->to('hr@foggersindia.com');

            $this->email->subject('New Career form submission');
            $this->email->message(''
                    . '<p>Name: '.$name.'</p>'
                    . '<p>Contact No.: '.$contact_no.'</p>'
                    . '<p>Email: '.$emailId.'</p>'
                    . '<p>Designation: '.$designation.'</p>'
                    . '<p>Experience: '.$experience.'</p>'
                    . '<p>Salary: '.$salary.'</p>'
                    . '<p>Location: '.$location.'</p>'
                    . '');
            $this->email->attach($cv_url);
            $this->email->send();
            
            // saving data
            $this->Page->insertData('career_form', $careerData);
            $this->session->set_flashdata('message', message_box('Your resume has beeen submit successfully.', 'success'));
            redirect('career', 'refresh');
        }

        $this->renderView('Home', 'pages/career', $data);
    }

    public function enquiry()
    {
//        error_reporting(E_ALL);
//        ini_set('display_errors', 1);
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('email_id', 'Email', 'required');
        $this->form_validation->set_rules('contact_no', 'Contact No', 'required|numeric|max_length[10]');
        $this->form_validation->set_rules('city', 'City', 'required');
        $this->form_validation->set_rules('state', 'State', 'required');
        $this->form_validation->set_rules('pincode', 'Pincode', 'required|numeric|max_length[6]');
        $this->form_validation->set_rules('inquiry_for', 'Inquiry For', 'required');

        if ($this->form_validation->run() == true) {
            $enquiryData = array(
                'name' => $this->input->post('name'),
                'product_id' => $this->input->post('product_id'),
                'company_name' => $this->input->post('company_name'),
                'email_id' => $this->input->post('email_id'),
                'contact_no' => $this->input->post('contact_no'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'pincode' => $this->input->post('pincode'),
                'country' => 'India',
                'inquiry_for' => $this->input->post('inquiry_for'),
                'description' => $this->input->post('description'),
                'created_at' => date('Y-m-d H:i:s'),
            );
            
            $this->Page->insertData('enquiries', $enquiryData);
            
            //Send Email
            
             $this->load->library('email');
            
            // SMTP SETUP Start
            $config = [];
            $config['protocol'] = 'mail';
            $config['smtp_host'] = 'smtp-mail.outlook.com';
            $config['smtp_user'] = 'sales@foggersindia.com';
            $config['smtp_pass'] = 'Growth@202425';
            $config['smtp_port'] = 587;
            $config['newline'] = "\r\n";
            $config['smtp_crypto'] = 'tls';
            
             $this->email->initialize($config);
             $this->email->set_crlf( "\r\n" );
            
            // SMTP SETUP End
            
             $this->email->from('sales@foggersindia.com', 'Foggers India');
//             $this->email->from('support@foggersindia.com', 'Foggers India');
             $this->email->set_mailtype("html");
             $this->email->to('sales@foggersindia.com');
             $this->email->to('support@foggersindia.com');
        
              
              $name = $this->input->post('name');
              $email = $this->input->post('email_id');
              $contact = $this->input->post('contact_no');
              $compalint =$this->input->post('inquiry_for');
            
   
            $data = array(
                    'MobileNo' => $contact,
                    'CustomerName' =>$name,
                    'Email' => $email,
                    'Complaint'=>$compalint,
                    'CompCode'=>'1311F4A5',
                );
            $json = http_build_query($data);
            $url = 'http://foggers.syncleadcube.com/FrmCompliantFromWebsite.aspx?';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url.$json);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            $response = curl_exec($ch);
            curl_close($ch);
            
            $this->email->subject('New Enquiry From Foggers India');
            $message = '<html><body><table>'
                    . '<tr><th>Name: </th><td>'.$this->input->post('name').'</td></tr>'
                    . '<tr><th>Company Name: </th><td>'.$this->input->post('company_name').'</td></tr>'
                    . '<tr><th>Email: </th><td>'.$this->input->post('email_id').'</td></tr>'
                    . '<tr><th>Contact No: </th><td>'.$this->input->post('contact_no').'</td></tr>'
                    . '<tr><th>Address: </th><td>'.$this->input->post('address').'</td></tr>'
                    . '<tr><th>City: </th><td>'.$this->input->post('city').'</td></tr>'
                    . '<tr><th>State: </th><td>'.$this->input->post('state').'</td></tr>'
                    . '<tr><th>Pincode: </th><td>'.$this->input->post('pincode').'</td></tr>'
                    . '<tr><th>Enquiry For: </th><td>'.$this->input->post('inquiry_for').'</td></tr>'
                    . '<tr><th>Description: </th><td>'.$this->input->post('description').'</td></tr>'
                    . '</table></body></html>';
            $this->email->message($message);
            $this->email->send();
            $this->session->set_flashdata('message', message_box('Enquiry has been submitted successfully.', 'success'));
         
            // if(curl_errno($ch)) {
            //     echo 'Error: ' . curl_error($ch);
            // } else {
            //     echo $response;
            // }
            
            
            // var_dump($response);
            // die;
            redirect('enquiry', 'refresh');
        }

        $data['newsData'] = $this->latestNews();
        $data['content'] = '';
        $data['page_name'] = 'enquiry';
        $this->renderView('Home', 'pages/enquiry', $data);
    }



    public function enquiry_one()
    {
     
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('email_id', 'Email', 'required');
        $this->form_validation->set_rules('contact_no', 'Contact No', 'required|numeric|max_length[10]');
        $this->form_validation->set_rules('city', 'City', 'required');
        $this->form_validation->set_rules('state', 'State', 'required');
        $this->form_validation->set_rules('pincode', 'Pincode', 'required|numeric|max_length[6]');
        $this->form_validation->set_rules('inquiry_for', 'Inquiry For', 'required');

        if ($this->form_validation->run() == true) {
            $enquiryData = array(
                'name' => $this->input->post('name'),
                'product_id' => $this->input->post('product_id'),
                'company_name' => $this->input->post('company_name'),
                'email_id' => $this->input->post('email_id'),
                'contact_no' => $this->input->post('contact_no'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'pincode' => $this->input->post('pincode'),
                'country' => 'India',
                'inquiry_for' => $this->input->post('inquiry_for'),
                'description' => $this->input->post('description'),
                'created_at' => date('Y-m-d H:i:s'),
            );
            
            $this->Page->insertData('enquiries', $enquiryData);
            
            //Send Email
            $this->load->library('email');
            
            // SMTP SETUP Start
            $config = [];
            $config['protocol'] = 'smtp';
            $config['smtp_host'] = 'smtp-mail.outlook.com';
            $config['smtp_user'] = 'sales@foggersindia.com';
            $config['smtp_pass'] = 'Growth@202425';
            $config['smtp_port'] = 587;
            $config['newline'] = "\r\n";
            $config['smtp_crypto'] = 'tls';
            $this->email->initialize($config);
            $this->email->set_crlf( "\r\n" );
            // SMTP SETUP End
            
//            $this->email->from('sales@foggersindia.com', 'Foggers India');
            $this->email->from('sales@foggersindia.com', 'Foggers India');
            $this->email->set_mailtype("html");
            $this->email->to('sales@foggersindia.com');
            $this->email->to('support@foggersindia.com');
            $this->email->to('prashant.01mca@gmail.com');
          
            

            $this->email->subject('New Enquiry From Foggers India');
            $message = '<html><body><table>'
                    . '<tr><th>Name: </th><td>'.$this->input->post('name').'</td></tr>'
                    . '<tr><th>Company Name: </th><td>'.$this->input->post('company_name').'</td></tr>'
                    . '<tr><th>Email: </th><td>'.$this->input->post('email_id').'</td></tr>'
                    . '<tr><th>Contact No: </th><td>'.$this->input->post('contact_no').'</td></tr>'
                    . '<tr><th>Address: </th><td>'.$this->input->post('address').'</td></tr>'
                    . '<tr><th>City: </th><td>'.$this->input->post('city').'</td></tr>'
                    . '<tr><th>State: </th><td>'.$this->input->post('state').'</td></tr>'
                    . '<tr><th>Pincode: </th><td>'.$this->input->post('pincode').'</td></tr>'
                    . '<tr><th>Enquiry For: </th><td>'.$this->input->post('inquiry_for').'</td></tr>'
                    . '<tr><th>Description: </th><td>'.$this->input->post('description').'</td></tr>'
                    . '</table></body></html>';
            $this->email->message($message);
            $this->email->send();
           // http://foggers.syncleadcube.com/FrmCompliantFromWebsite.aspx?MobileNo=XXXXX&CustomerName=XXXXX&Email=XXXXX&Complaint=XXXXX&CompCode=1311F4A5
            $this->session->set_flashdata('message', message_box('Enquiry has been submitted successfully.', 'success'));
            redirect('enquiry', 'refresh');
        }

        $data['newsData'] = $this->latestNews();
        $data['content'] = '';
        $data['page_name'] = 'enquiry';
        $this->renderView('Home', 'pages/enquiry', $data);
    }



    public function productEnquiry($id = null)
    {

        $data['newsData'] = $this->latestNews();
        $data['content'] = '';
        $data['page_name'] = 'enquiry';
        $data['p_id'] = $id;
        $this->renderView('Home', 'pages/enquiry', $data);
    }

    public function news()
    {

        $data['content'] = '';
        $data['newsData'] = $this->latestNews();
        $data['news'] = $this->latestNews();
        $data['page_name'] = 'news';
        $this->renderView('Home', 'pages/news', $data);
    }

    public function locations()
    {
        $data['newsData'] = $this->latestNews();
        $data['content'] = '';
        $data['locations'] = $this->Page->get_locations_list();
        $data['page_name'] = 'locations';
        $this->renderView('Location', 'pages/locations', $data);
    }

    public function download($fileName = '')
    {
        $fileName =  $this->input->get('path', TRUE);
        $this->load->helper('download');
        if ($fileName) {
            $file = site_url() . $fileName;
            // check file exists    
            if (file_exists($fileName)) {
                // get file content
                $data = file_get_contents($file);
                //force download
                $new_name = str_replace('assets/uploads/', '', $fileName);
                force_download($new_name, $data);
            } else {
                // Redirect to base url
                redirect(base_url());
            }
        }
    }

}
