<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Partners extends MY_Controller {

    function __construct()
    {
        parent::__construct();
        $this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
        $this->lang->load('auth');
        $this->load->model('User');
        $this->load->model('Group');
        $this->load->model('File_manager_model');

        $this->data['parent_menu'] = 'partner';
    }
    
    public function logout()
    {
        $this->ion_auth->logout();
        $this->session->set_flashdata('message', message_box('You have signed out successfully', 'success'));
        redirect('/', 'refresh');
    }

    public function login()
    {
        $data['content'] = '';
        $data['page_name'] = 'login';

        if ($this->ion_auth->logged_in() && $this->ion_auth->current_role() == 'Partners') {
            redirect('partners/dashboard');
        }
        //validate form input
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');

        if ($this->form_validation->run() == true) {
            //check to see if the user is logging in
            //check for "remember me"

            $name = $this->input->post('name');
            $pass = $this->input->post('password');
            $email = '';
            $user_data =  $this->db->query("SELECT `email` FROM users WHERE username = '$name'")->row_array();
            
            $email = $user_data['email'];
            
            if ($this->ion_auth->login($email, $pass)) {
                //if the login is successful
                //redirect them back to the home page
                $this->session->set_flashdata('message', message_box('Successfull', 'success'));
                redirect('partners/dashboard', 'refresh');
            } else {
                //if the login was un-successful
                //redirect them back to the login page
                $this->session->set_flashdata('message', message_box($this->ion_auth->errors(), 'danger'));
                redirect('partners/login', 'refresh'); //use redirects instead of loading views for compatibility with MY_Controller libraries
            }
        }
        $this->renderView('Home', 'partners/login', $data);
    }

    public function dashboard()
    {
        
        if($this->ion_auth->current_role() != 'Partners'){
            redirect('partners/login');
        }
        
        $data['content'] = '';
        $data['page_name'] = 'Distributor Admin';

        $data['files'] = $this->File_manager_model->find();
        $this->renderView('Distributor Admin', 'partners/dashboard', $data);
    }

}
