<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class File_manager extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('File_manager_model');

        $this->allow_group_access(array('admin', 'members'));
        $this->data['parent_menu'] = 'file-manager';
        $this->data['page_title'] = 'File Manager';
    }

    public function index()
    {
        $config['base_url'] = site_url('admin/file-manager/index/');
        $config['total_rows'] = count($this->File_manager_model->find());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['files'] = $this->File_manager_model->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['files'])) {
                $this->session->set_flashdata('message', message_box('Data tidak ditemukan', 'danger'));
                redirect('admin/file-manager/index');
            }
            $config['total_rows'] = count($this->data['files']);
        else:
            $this->data['files'] = $this->File_manager_model->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);

        $this->load_admin('file_manager/index');
    }

    public function add()
    {
        if ($this->input->post('form_submit') == 'true') {

            $this->form_validation->set_rules('file_name', 'File Name', 'required');
            if ($_FILES['file']['error'] == 4) {
                $this->form_validation->set_rules('file', 'File', 'required');
            }
            $this->form_validation->set_error_delimiters('', '<br/>');
            if ($this->form_validation->run() == TRUE) {

                $data = $_POST;
                // print_data($data);exit;
                $data['file_name'] = $this->input->post('file_name');

                // Hnadling File Upload
                $config['upload_path'] = $this->assets_path;
                $config['allowed_types'] = $this->Setting->findByKey('file_type');
                $config['max_size'] = $this->Setting->findByKey('file_max_size');
                $this->load->library('upload', $config);
                $img_url = '';
                $imageData = [];
                if ($_FILES['file']['error'] != 4) {
                    if ($this->upload->do_upload("file")) {
                        $imageData = $this->upload->data();
                        $img_url = $this->assets_path . $imageData['orig_name'];
                    }
                }

                $data['file_url'] = $img_url;
                $data['file'] = $imageData['orig_name'];
                $data['created_at'] = date("Y-m-d H:i:s");
                $data['updated_at'] = date("Y-m-d H:i:s");

                $this->File_manager_model->create($data);
                $this->session->set_flashdata('message', message_box('New file has been saved.', 'success'));
                redirect('admin/file_manager');
            }
        }

        $this->load_admin('file_manager/add');
    }

    public function edit($id = null)
    {
        if ($id == null) {
            $id = $this->input->post('id');
        }
        if ($this->input->post('form_submit') == 'true') {
            $this->form_validation->set_rules('file_name', 'File Name', 'required');
            if ($_FILES['file']['error'] == 4) {
                $this->form_validation->set_rules('file', 'File', 'required');
            }
            $this->form_validation->set_error_delimiters('', '<br/>');
            if ($this->form_validation->run() == TRUE) {

                $data = $_POST;
                // print_data($data);exit;
                $data['file_name'] = $this->input->post('file_name');

                // Hnadling File Upload
                $config['upload_path'] = $this->assets_path;
                $config['allowed_types'] = $this->Setting->findByKey('image_type');
                $config['max_size'] = $this->Setting->findByKey('image_max_size');
                $this->load->library('upload', $config);
                $img_url = '';
                $imageData = [];
                if ($_FILES['file']['error'] != 4) {
                    if ($this->upload->do_upload("file")) {
                        $imageData = $this->upload->data();
                        $img_url = $this->assets_path . $imageData['orig_name'];
                    }
                }

                $data['file_url'] = $img_url;
                $data['file'] = $imageData['orig_name'];
                $data['updated_at'] = date("Y-m-d H:i:s");

                $this->File_manager_model->update($data, $id);
                $this->session->set_flashdata('message', message_box('File has been updated.', 'success'));
                redirect('admin/file-manager');
            }
        }
        $this->data['file'] = $this->File_manager_model->find_by_id($id);
        $this->data['id'] = $id;
        $this->load_admin('file_manager/edit');
    }

    public function delete($id = null)
    {
        if (!empty($id)) {
            $this->File_manager_model->delete($id);
            $this->session->set_flashdata('message', message_box('File has been deleted', 'success'));
            redirect('admin/file-manager');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/file-manager');
        }
    }

}
