<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php

class Forms extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->allow_group_access(array('admin'));
        $this->load->model('Form');
        $this->data['parent_menu'] = 'forms';
    }

    public function career()
    {
        $config['base_url'] = site_url('admin/forms/career/');
        $config['total_rows'] = count($this->Form->find_career_form());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $this->data['forms'] = $this->Form->find_career_form($config['per_page'], $this->uri->segment(4));
        $this->data['pagination'] = $this->bootstrap_pagination($config);
        $this->load_admin('forms/career');
    }

    public function enquiries()
    {
        $config['base_url'] = site_url('admin/forms/enquiries/');
        $config['total_rows'] = count($this->Form->find_career_form());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $this->data['forms'] = $this->Form->find_enquiry_form($config['per_page'], $this->uri->segment(4));
        $this->data['pagination'] = $this->bootstrap_pagination($config);
        $this->load_admin('forms/enquiry');
    }

    public function career_delete($id = null)
    {
        if (!empty($id)) {
            $this->Form->career_delete($id);
            $this->session->set_flashdata('message', message_box('Entry has been deleted', 'success'));
            redirect('admin/forms/career');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/forms/career');
        }
    }

    public function enquiries_delete($id = null)
    {
        if (!empty($id)) {
            $this->Form->enquiry_delete($id);
            $this->session->set_flashdata('message', message_box('Entry has been deleted', 'success'));
            redirect('admin/forms/enquiry');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/forms/enquiry');
        }
    }

}
