<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php

class Locations extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->allow_group_access(array('admin'));
        $this->load->model('Location');
        $this->data['parent_menu'] = 'locations';
    }

    public function index()
    {
        $config['base_url'] = site_url('admin/locations/index/');
        $config['total_rows'] = count($this->Location->find());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['pages'] = $this->Location->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['locations'])) {
                $this->session->set_flashdata('message', message_box('Data not found.', 'danger'));
                redirect('admin/locations/index');
            }
            $config['total_rows'] = count($this->data['pages']);
        else:
            $this->data['locations'] = $this->Location->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);
        $this->load_admin('locations/index');
    }

    public function add()
    {

        $this->form_validation->set_rules('title', 'Title', 'required');
        $this->form_validation->set_rules('post_code', 'Post Code', 'required|numeric');
        $this->form_validation->set_rules('address', 'Address', 'required');
        $this->form_validation->set_error_delimiters('', '<br/>');
        if ($this->form_validation->run() == TRUE) {

            $data = $this->input->post();
            $locationData = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyAwUB0tX4eGDm3BeCfxEhYJfdiGrOezoyE&address=' . $data['post_code']);
            $arrayData = json_decode($locationData);
            if (!empty($arrayData)) { 
                $data['lat'] = $arrayData->results[0]->geometry->location->lat;
                $data['long'] = $arrayData->results[0]->geometry->location->lng;
            } else {
                $data['lat'] = '';
                $data['long'] = '';
            }
            $data['created_at'] = date("Y-m-d H:i:s");
            $data['updated_at'] = date("Y-m-d H:i:s");

            $this->Location->create($data);

            $this->session->set_flashdata('message', message_box('New location has been saved', 'success'));
            redirect('admin/locations');
        }

        $this->load_admin('locations/add');
    }

    public function edit($id = null)
    {
        if ($id == null) {
            $id = $this->input->post('id');
        }


        $this->form_validation->set_rules('title', 'Title', 'required');
        $this->form_validation->set_rules('post_code', 'Post Code', 'required|numeric');
        $this->form_validation->set_rules('address', 'Address', 'required');
        $this->form_validation->set_error_delimiters('', '<br/>');
        if ($this->form_validation->run() == TRUE) {
            $data = $_POST;

            $locationData = file_get_contents('http://maps.googleapis.com/maps/api/geocode/json?address=' . $data['post_code']);
            $arrayData = json_decode($locationData);

            $data['lat'] = $arrayData->results[0]->geometry->location->lat;
            $data['long'] = $arrayData->results[0]->geometry->location->lng;
            $data['updated_at'] = date("Y-m-d H:i:s");
            $this->Location->update($data, $id);

            $this->session->set_flashdata('message', message_box('Location has been saved', 'success'));
            redirect('admin/locations');
        }
        $this->data['location'] = $this->Location->find_by_id($id);

        $this->load_admin('locations/edit');
    }

    public function delete($id = null)
    {
        if (!empty($id)) {
            $this->Location->delete($id);
            $this->session->set_flashdata('message', message_box('Location has been deleted', 'success'));
            redirect('admin/locations/index');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/locations/index');
        }
    }

}
