<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Member_files extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Member_file_model');

        $this->allow_group_access(array('admin', 'members'));
        $this->data['parent_menu'] = 'member-files';
        $this->data['page_title'] = 'Member Files';
    }

    public function index()
    {
        $config['base_url'] = site_url('admin/member-files/index/');
        $config['total_rows'] = count($this->Member_file_model->find());
        $config['per_page'] = 25;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['files'] = $this->Member_file_model->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['files'])) {
                $this->session->set_flashdata('message', message_box('Data not found', 'danger'));
                redirect('admin/member-files/index');
            }
            $config['total_rows'] = count($this->data['files']);
        else:
            $this->data['files'] = $this->Member_file_model->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);

        $this->load_admin('member_files/index');
    }

    public function add()
    {
        if ($this->input->post('form_submit') == 'true') {

            $this->form_validation->set_rules('file_name', 'File Name', 'required');
            if ($_FILES['file']['error'] == 4) {
                $this->form_validation->set_rules('file', 'File', 'required');
            }
            $this->form_validation->set_error_delimiters('', '<br/>');
            if ($this->form_validation->run() == TRUE) {

                $data['file_name'] = $this->input->post('file_name');
                $data['file_group_name'] = $this->input->post('file_group_name');

                // Hnadling File Upload
                $config['upload_path'] = $this->assets_path;
                $config['allowed_types'] = $this->Setting->findByKey('file_type');
                $config['max_size'] = $this->Setting->findByKey('file_max_size');
                $this->load->library('upload', $config);
                $file_url = '';
                $fileData = [];
                if ($_FILES['file']['error'] == 0) {
                    if ($this->upload->do_upload("file")) {
                        $fileData = $this->upload->data();
                        $file_url = $this->assets_path . $fileData['orig_name'];
                        
                         
                        $data['file_url'] = $file_url;
                        $data['file'] = $fileData['orig_name'];
                        $data['created_at'] = date("Y-m-d H:i:s");
                        $data['updated_at'] = date("Y-m-d H:i:s");
            
                        $this->Member_file_model->create($data);
                        $this->session->set_flashdata('message', message_box('New file has been saved.', 'success'));
                    } else {
                        //echo $this->upload->display_errors();
                        $this->session->set_flashdata('message', message_box($this->upload->display_errors(), 'danger'));
                    }
                }

               
                redirect('admin/member-files');
            }
        }

        $this->load_admin('member_files/add');
    }

    public function edit($id = null)
    {
        if ($id == null) {
            $id = $this->input->post('id');
        }
        if ($this->input->post('form_submit') == 'true') {
            $this->form_validation->set_rules('file_name', 'File Name', 'required');
            if ($_FILES['file']['error'] == 4) {
                $this->form_validation->set_rules('file', 'File', 'required');
            }
            $this->form_validation->set_error_delimiters('', '<br/>');
            if ($this->form_validation->run() == TRUE) {

                $data = $_POST;
                // print_data($data);exit;
                $data['file_name'] = $this->input->post('file_name');

                // Hnadling File Upload
                $config['upload_path'] = $this->assets_path;
                $config['allowed_types'] = $this->Setting->findByKey('image_type');
                $config['max_size'] = $this->Setting->findByKey('image_max_size');
                $this->load->library('upload', $config);
                $img_url = '';
                $imageData = [];
                if ($_FILES['file']['error'] != 4) {
                    if ($this->upload->do_upload("file")) {
                        $imageData = $this->upload->data();
                        $img_url = $this->assets_path . $imageData['orig_name'];
                    }
                }

                $data['file_url'] = $img_url;
                $data['file'] = $imageData['orig_name'];
                $data['updated_at'] = date("Y-m-d H:i:s");

                $this->Member_file_model->update($data, $id);
                $this->session->set_flashdata('message', message_box('File has been updated.', 'success'));
                redirect('admin/member-files');
            }
        }
        $this->data['file'] = $this->Member_file_model->find_by_id($id);
        $this->data['id'] = $id;
        $this->load_admin('member_files/edit');
    }

    public function delete($id = null)
    {
        if (!empty($id)) {
            $this->Member_file_model->delete($id);
            $this->session->set_flashdata('message', message_box('File has been deleted.', 'success'));
            redirect('admin/member-files');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/member-files');
        }
    }

}
