<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php

class Orders extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->allow_group_access(array('admin'));
        $this->load->model('Order');
        $this->data['parent_menu'] = 'orders';
    }
    
    public function index() {
        $config['base_url'] = site_url('admin/orders/index/');
        $config['total_rows'] = count($this->Order->find());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['orders'] = $this->Order->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['orders'])) {
                $this->session->set_flashdata('message', message_box('Data not found.', 'danger'));
                redirect('admin/orders/index');
            }
            $config['total_rows'] = count($this->data['pages']);
        else:
            $this->data['orders'] = $this->Order->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);
        $this->load_admin('orders/index');
    }
    
    public function edit($id = null) {

        $this->load_admin('orders/edit');
    }

    public function delete($id = null) {
        if (!empty($id)) {
            $this->Form->delete($id);
            $this->session->set_flashdata('message', message_box('order has been deleted', 'success'));
            redirect('admin/orders/index');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/orders/index');
        }
    }
}