<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Product');
        $this->load->model('Product_category_model');

        $this->allow_group_access(array('admin', 'members'));
        $this->data['parent_menu'] = 'product';
        $this->data['page_title'] = 'Products';
    }

    public function index()
    {
        $config['base_url'] = site_url('admin/products/index/');
        $config['total_rows'] = count($this->Product->find());
        $config['per_page'] = 25;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['products'] = $this->Product->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['products'])) {
                $this->session->set_flashdata('message', message_box('No record found', 'danger'));
                redirect('admin/products/index');
            }
            $config['total_rows'] = count($this->data['products']);
        else:
            $this->data['products'] = $this->Product->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);

        $this->load_admin('products/index');
    }

    public function add()
    {

        $this->form_validation->set_rules('title', 'title', 'required|is_unique[posts.title]');
        $this->form_validation->set_error_delimiters('', '<br/>');
        if ($this->form_validation->run() == TRUE) {

            $data = $this->input->post();
            // Hnadling File Upload
            $config['upload_path'] = $this->assets_path;
            $config['allowed_types'] = 'gif|jpg|png|pdf|ppt|docx';
            $config['max_size'] = 10000;
            $this->load->library('upload', $config);

            if (isset($_FILES['featured_image']) && $_FILES['featured_image']['error'] != 4) {
                if ($this->upload->do_upload("featured_image")) {
                    $imageData = $this->upload->data();
                    $img_url = $this->assets_path . $imageData['orig_name'];
                }
            }
            if (isset($_FILES['file_upload']) && $_FILES['file_upload']['error'] != 4) {
                if ($this->upload->do_upload("file_upload")) {
                    $fileData = $this->upload->data();
                    $file_url = $this->assets_path . $fileData['orig_name'];
                }
            }
            if (isset($_FILES['photo_spare_part']) && $_FILES['photo_spare_part']['error'] != 4) {
                if ($this->upload->do_upload("photo_spare_part")) {
                    $photo_sparepart_pdf = $this->upload->data();
                    $photo_url = $this->assets_path . $photo_sparepart_pdf['orig_name'];
                }
            }
            unset($data['category']);
            $data['created'] = date("Y-m-d H:i:s");
            $data['modified'] = date("Y-m-d H:i:s");
            $data['user_id'] = $this->session->userdata('user_id');
            $data['file_link'] = isset($file_url) ? $file_url : '';
            $data['featured_image'] = isset($img_url) ? $img_url : '';
            $data['photo_sparepart_link'] = isset($photo_url) ? $photo_url : '';
            $data['video_link'] = $data['video_link'];
            $data['published_at'] = $data['published_at'];
            $data['is_front'] = $data['is_front'];
            $data['order'] = $data['order'];

            if (!$this->ion_auth->is_admin()) {
                $data['status'] = 0;
            }
            
            $this->Product->create($data);

            $post_id = $this->db->insert_id();

            if (!empty($_POST['category'])) {
                foreach ($_POST['category'] as $key => $cat_id) {
                    $post_category = array(
                        'product_id' => $post_id,
                        'product_category_id' => $cat_id
                    );
                    $this->db->insert('product_category_relation', $post_category);
                }
            }
            
            if (!empty($_FILES['images']['name'][0])) {
                $p_images = $this->upload_files('pi', $_FILES['images']);
                if ($p_images === FALSE) {
                    $data['error'] = $this->upload->display_errors('<div class="alert alert-danger">', '</div>');
                }else{
                    foreach ($p_images as $p_image) {
                        $p_data = array(
                        'product_id' => $post_id,
                        'image_name' => $p_image
                    );
                    $this->db->insert('product_images', $p_data);
                    }
                }
            } 

            $this->session->set_flashdata('message', message_box('New post has been saved', 'success'));
            redirect('admin/products');
        }
        $this->data['categories'] = $this->Product_category_model->find_list();
        $this->load_admin('products/add');
    }

    public function edit($id = null)
    {
        if ($id == null) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('title', 'title', 'required');

        $this->form_validation->set_error_delimiters('', '<br/>');
        if ($this->form_validation->run() == TRUE) {

            $data = $_POST;
            unset($data['category']);
            unset($data['tag']);

            // Hnadling File Upload
            $config['upload_path'] = $this->assets_path;
            $config['allowed_types'] = 'gif|jpg|png|pdf|ppt|docx';
            //$config['max_size'] = $this->Setting->findByKey('image_max_size');
            $config['max_size'] = 10000;
            $this->load->library('upload', $config);
           
            $featured_image = '';
            if (isset($_FILES['featured_image']) && $_FILES['featured_image']['error'] != 4) {
                if ($this->upload->do_upload("featured_image")) {
                    $imageData = $this->upload->data();
                    $featured_image = $this->assets_path . $imageData['orig_name'];
                }else{
                   //echo $this->upload->display_errors();
                }
            } else {
                $featured_image = $data['old_featured_image'];
            }
            $file_url = '';
            if (isset($_FILES['file_upload']) && $_FILES['file_upload']['error'] != 4) {
                if ($this->upload->do_upload("file_upload")) {
                    $fileData = $this->upload->data();
                    $file_url = $this->assets_path . $fileData['orig_name'];
                }else{
                   //echo $this->upload->display_errors();
                }
            } else {
                $file_url = $data['old_file_upload'];
            }
            $photo_url = '';
            if (isset($_FILES['photo_spare_part']) && $_FILES['photo_spare_part']['error'] != 4) {
                if ($this->upload->do_upload("photo_spare_part")) {
                    $photo_sparepart_pdf = $this->upload->data();
                    $photo_url = $this->assets_path . $photo_sparepart_pdf['orig_name'];
                }else{
                   echo $this->upload->display_errors();
                }
            } else {
                $photo_url = $data['old_photo_spare_part'];
            }

            $data['modified'] = date("Y-m-d H:i:s");
            
            $updateData = array(
                'title' => $data['title'],
                'body' => $data['body'],
                'featured_image' => $featured_image,
                'file_link' => $file_url,
                'photo_sparepart_link' => $photo_url,
                'video_link' => $data['video_link'],
                'published_at' => $data['published_at'],
                'is_front' => $data['is_front'],
                'status' => $data['status'],
                'order' => $data['order'],
                'modified' => date("Y-m-d H:i:s"),
                'user_id' => $this->session->userdata('user_id')
            );
            
            $this->Product->update($updateData, $id);

            $post_id = $id;

            if (!empty($_POST['category'])) {
                $this->db->where('product_id', $post_id);
                $this->db->where_not_in('product_category_id', $_POST['category']);
                $this->db->delete('product_category_relation');
                    
                foreach ($_POST['category'] as $key => $cat_id) {

                    if ($this->db->where(array('product_id' => $post_id, 'product_category_id' => $cat_id))->get('product_category_relation', 1)->num_rows() < 1) {
                        $post_category = array(
                            'product_id' => $post_id,
                            'product_category_id ' => $cat_id
                        );
                        $this->db->insert('product_category_relation', $post_category);
                    }
                }
            }
            
            if (!empty($_FILES['images']['name'][0])) {
                $p_images = $this->upload_files('pi', $_FILES['images']);
                if ($p_images === FALSE) {
                    $data['error'] = $this->upload->display_errors('<div class="alert alert-danger">', '</div>');
                }else{
                    $this->db->where('product_id', $id);
                    $this->db->delete('product_images');
                    foreach ($p_images as $p_image) {
                        $p_data = array(
                        'product_id' => $post_id,
                        'image_name' => $p_image
                    );
                    $this->db->insert('product_images', $p_data);
                    }
                }
            } 

            $this->session->set_flashdata('message', message_box('Product has been saved', 'success'));
            redirect('admin/products/edit/' . $id);
        }
        $this->data['product'] = $this->Product->find_by_id($id);
        $this->data['product_thumbnails'] = $this->Product->product_thumbnails($id);
        $this->data['categories'] = $this->Product_category_model->find_list();
        $current_category = $this->db->select('product_category_id')->where(array('product_id' => $this->data['product']['id']))->get('product_category_relation')->result_array();
        $category_ids = array();
        if (!empty($current_category)) {
            foreach ($current_category as $current) {
                $category_ids[] = $current['product_category_id'];
            }
        }

        $this->data['category_ids'] = $category_ids;

        $this->load_admin('products/edit');
    }

    public function delete($id = null)
    {
        if (!empty($id)) {
            $this->Product->delete($id);
            $images = $this->db->query("SELECT image_name FROM product_images where product_id = $id")->result_array();
            foreach ($images as $image) {
                unlink("assets/product_images/".$image['image_name']);
            }
            $this->session->set_flashdata('message', message_box('Product has been deleted', 'success'));
            redirect('admin/products/index');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/products/index');
        }
    }
    
    //https://stackoverflow.com/questions/20113832/multiple-files-upload-in-codeigniter
    private function upload_files($title, $files)
    {
        $config = array(
            'upload_path'   => './assets/product_images/',
            'allowed_types' => 'jpg|gif|png|jpeg',
            'overwrite'     => 1,                       
            );

        $this->load->library('upload', $config);

        $images = array();
        foreach ($files['name'] as $key => $image) {
            $_FILES['images[]']['name']= $files['name'][$key];
            $_FILES['images[]']['type']= $files['type'][$key];
            $_FILES['images[]']['tmp_name']= $files['tmp_name'][$key];
            $_FILES['images[]']['error']= $files['error'][$key];
            $_FILES['images[]']['size']= $files['size'][$key];

            $fileName = $title .'_'. $image;

            $images[] = $fileName;

            $config['file_name'] = $fileName;

            $this->upload->initialize($config);
            if ($this->upload->do_upload('images[]')) {
                $this->upload->data();
            } else {
                return false;
            }
        }
        return $images;
    }

}
