<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Products_category extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Product_category_model');
        $this->allow_group_access(array('admin'));
        $this->data['parent_menu'] = 'product';
    }

    public function index() {
        $config['base_url'] = site_url('admin/product-category/index/');
        $config['total_rows'] = count($this->Product_category_model->find());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $this->data['categories'] = $this->Product_category_model->find($config['per_page'], $this->uri->segment(4));

        $this->data['pagination'] = $this->bootstrap_pagination($config);
        $this->load_admin('products_category/index');
    }

    public function add() {
        $this->form_validation->set_rules('name', 'name', 'required|is_unique[products_category.name]');
        $this->form_validation->set_rules('status', 'status', 'required');

        if ($this->form_validation->run() == true) {
            $category = array(
                'name' => $this->input->post('name'),
                'status' => $this->input->post('status'),
                'created' => date('Y-m-d H:i:s'),
                'modified' => date('Y-m-d H:i:s'),
            );
            $this->Product_category_model->create($category);
            $this->session->set_flashdata('message', message_box('Category has been saved', 'success'));
            redirect('admin/product-category');
        }
        $this->data['categories'] = $this->Product_category_model->find();
        $this->load_admin('products_category/add');
    }

    public function edit($id = null) {
        $cat_id = $id;
        $this->form_validation->set_rules('name', 'name', 'required');
        $this->form_validation->set_rules('status', 'status', 'required');

        if ($this->form_validation->run() == true) {
            $category = array(
                'name' => $this->input->post('name'),
                'status' => $this->input->post('status'),
                'modified' => date('Y-m-d H:i:s'),
            );
            $this->Product_category_model->update($category, $cat_id);
            $this->session->set_flashdata('message', message_box('Category has been updated successfully.', 'success'));
            redirect('admin/product-category');
        }
        $this->data['categories'] = $this->Product_category_model->find();
        $this->data['cat_data'] = $this->Product_category_model->find_by_id($cat_id);
        $this->load_admin('products_category/edit');
    }

    public function delete($id = null) {
        if (!empty($id)) {
            $this->Product_category_model->delete($id);
            $this->session->set_flashdata('message', message_box('Category has been deleted', 'success'));
            redirect('admin/product-category');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/product-category');
        }
    }

}
