<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Sliders extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Slider');
        $this->allow_group_access(array('admin', 'members'));
        $this->data['parent_menu'] = 'slider';
        $this->data['page_title'] = 'Slider';
    }

    public function index()
    {
        $config['base_url'] = site_url('admin/slider/index/');
        $config['total_rows'] = count($this->Slider->find());
        $config['per_page'] = 10;
        $config["uri_segment"] = 4;

        $user_id = null;

        if (!in_array('admin', $this->current_groups)) {
            $user_id = $this->session->userdata('user_id');
        }


        if ($this->input->get('q')):
            $q = $this->input->get('q');
            $this->data['sliders'] = $this->Slider->find($config['per_page'], $this->uri->segment(4), $user_id, $q);
            if (empty($this->data['sliders'])) {
                $this->session->set_flashdata('message', message_box('Data tidak ditemukan', 'danger'));
                redirect('admin/slider/index');
            }
            $config['total_rows'] = count($this->data['sliders']);
        else:
            $this->data['sliders'] = $this->Slider->find($config['per_page'], $this->uri->segment(4), $user_id);
        endif;
        $this->data['pagination'] = $this->bootstrap_pagination($config);

        $this->load_admin('slider/index');
    }

    public function add()
    {
        if (isset($_POST['slider_add'])) {
            $config['upload_path'] = $this->assets_path;
            $config['allowed_types'] = $this->Setting->findByKey('image_type');
            $config['max_size'] = $this->Setting->findByKey('image_max_size');
            $this->load->library('upload', $config);

            if ($_FILES['featured_image']['error'] != 4) {
                if ($this->upload->do_upload("featured_image")) {
                    $imageData = $this->upload->data();
                    $img_url = $this->assets_path . $imageData['orig_name'];
                }

                $data['title'] = $this->input->post('slide_title');
                $data['order'] = $this->input->post('order');
                $data['status'] = $this->input->post('status');
                $data['image'] = isset($img_url) ? $img_url : '';
                $data['created_at'] = date("Y-m-d H:i:s");
                $data['updated_at'] = date("Y-m-d H:i:s");
                $data['user_id'] = $this->session->userdata('user_id');

                $this->Slider->create($data);

                $this->session->set_flashdata('message', message_box('Slide has been saved.', 'success'));
                redirect('admin/sliders');
            }
        }
        $this->load_admin('slider/add');
    }

    public function delete($id = null)
    {
        if (!empty($id)) {
            $this->Slider->delete($id);
            $this->session->set_flashdata('message', message_box('slider has been deleted.', 'success'));
            redirect('admin/sliders/index');
        } else {
            $this->session->set_flashdata('message', message_box('Invalid id', 'danger'));
            redirect('admin/sliders/index');
        }
    }

}
