<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Location extends CI_Model {

    var $table = 'locations';
    
    function find($limit = null, $offset = 0, $user_id = null, $q = null) {
        $this->db->select('locations.*');
        if ($q != null) {
            $this->db->like('title', $q);
        }
        if ($user_id != null) {
            $this->db->where('id', $user_id);
        }
        $this->db->limit($limit, $offset);
        $this->db->order_by('created_at', 'ASC');
        $query = $this->db->get($this->table);

        return $query->result_array();
    }

    function create($location) {
        $location['title'] = $location['title'];
        $location['post_code'] = $location['post_code'];
        $location['address'] = trim(preg_replace('/\s\s+/', ' ', $location['address']));
        $this->db->insert($this->table, $location);
    }

    function update($location, $id) {
        $location['title'] = $location['title'];
        $location['post_code'] = $location['post_code'];
        $location['address'] = trim(preg_replace('/\s\s+/', ' ', $location['address']));
        $this->db->where('id', $id);
        $this->db->update($this->table, $location);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    function find_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get($this->table, 1)->row_array();
    }

}