<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Member_file_model extends CI_Model {

    var $table = 'member_files';

    /**
     * Function to get list of files
     * @param int $limit
     * @param int $offset
     * @return array
     */
    function find($limit = null, $offset = 0)
    {
        $this->db->select('id,file_name,file_url,file_group_name,file,created_at');
        $this->db->limit($limit, $offset);
        $this->db->order_by('created_at', 'desc');
        $query = $this->db->get($this->table);
        return $query->result_array();
    }
    
    /**
     * Function to get file by id
     * @param int $id
     * @return array
     */
    public function find_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get($this->table, 1)->row_array();
    }

    /**
     * function to save file in database
     * @param array $file
     */
    function create(array $file)
    {
        $this->db->insert($this->table, $file);
    }

    /**
     * function to save update file
     * @param array $file
     * @param int $id
     */
    function update(array $file, $id)
    {
        $this->db->where('id', $id);
        $this->db->update($this->table, $file);
    }

    /**
     * Function to delete file
     * @param int $id
     */
    function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

}
