<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Model {

    var $table = 'orders';
    
    function find($limit = null, $offset = 0, $user_id = null, $q = null) {
        $this->db->select('orders.*,users.username');
        $this->db->join('users', 'users.id = orders.user_id');
        if ($user_id != null) {
            $this->db->where('orders.user_id', $user_id);
        }
        $this->db->limit($limit, $offset);
        $this->db->order_by('orders.created_at', 'desc');
        $query = $this->db->get($this->table);

        return $query->result_array();
    }
    
    public function add() {

        $this->form_validation->set_rules('product_title', 'Product Title', 'required');
        $this->form_validation->set_rules('code', 'Code', 'required|numeric');
        $this->form_validation->set_rules('price', 'Price', 'required');
        $this->form_validation->set_rules('quantity', 'Quantity', 'required');
        $this->form_validation->set_error_delimiters('', '<br/>');
        if ($this->form_validation->run() == TRUE) {

            $data = $_POST;
            $data['created_at'] = date("Y-m-d H:i:s");
            $data['updated_at'] = date("Y-m-d H:i:s");

            $this->Order->create($data);

            $this->session->set_flashdata('message', message_box('New location has been saved', 'success'));
            redirect('dashboard');
        }

        $this->load_admin('dashboard/');
    }
    
    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

}
