<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Model {

    var $table = 'products';

    function find($limit = null, $offset = 0, $user_id = null, $q = null) {
        // SELECT pt.post_id AS `post_id`, GROUP_CONCAT(t.tag) AS `tags`
        // FROM post_tags AS pt
        // INNER JOIN tags AS t ON pt.tag_id = t.tag_id
        // GROUP BY `post_id`
        $this->db->select('products.*,users.username');
        $this->db->join('users', 'users.id = products.user_id');
        if ($q != null) {
            $this->db->like('title', $q);
        }
        if ($user_id != null) {
            $this->db->where('user_id', $user_id);
        }
        $this->db->limit($limit, $offset);
        $this->db->order_by('order', 'DESC');
        $query = $this->db->get($this->table);

        return $query->result_array();
    }
    
    public function find_latest_product()
    {
        $this->db->select('products.*,users.username');
        $this->db->join('users', 'users.id = products.user_id');
        $this->db->where('products.is_front', 'yes');
        $this->db->limit(12, 0);
        $query = $this->db->get($this->table);

        return $query->result_array();
    }

    function find_active($limit = null, $offset = 0, $q = null) {
        $this->db->select('products.*,users.username');
        $this->db->join('users', 'users.id = products.user_id');
        if ($q != null) {
            $this->db->like('title', $q);
        }
        $this->db->where('status', 1);
        $this->db->limit($limit, $offset);
        $this->db->order_by('published_at', 'desc');
        $query = $this->db->get($this->table);

        return $query->result_array();
    }

    function find_by_category($slug, $limit = null, $offset = 0) {
//        $this->db->select('p.*,u.username');
//        $this->db->from('`products` AS `p`');
//        $this->db->join('product_category_relation AS pcr', '`pcr`.`product_id`=`p`.`id`','left');
//        $this->db->join('products_category AS pc', '`pcr`.`product_category_id`=`pc`.`id`');
//        $this->db->join('users u', 'p.user_id=u.id');
//        $this->db->where('p.status', 1);
//        $this->db->where('pc.slug', $slug);
//        $this->db->group_by('pcr.product_id');
//        $this->db->order_by("`p`.`order` = 0, `p`.`order` ASC");
        $limit_sql = '';
        if($limit !== NULL){
            $limit_sql = " LIMIT $limit OFFSET $offset";
        }
       $sql = "SELECT `p`.*, `u`.`username` FROM `products` AS `p` 
LEFT JOIN `product_category_relation` AS `pcr` ON `pcr`.`product_id`=`p`.`id` 
JOIN `products_category` AS `pc` ON `pcr`.`product_category_id`=`pc`.`id` 
JOIN `users` `u` ON `p`.`user_id`=`u`.`id` 
WHERE `p`.`status` = 1 AND `pc`.`slug` = '$slug' 
GROUP BY `pcr`.`product_id` 
ORDER BY `p`.`order` = 0, `p`.`order` ASC$limit_sql";
       $products = $this->db->query($sql)->result_array();
//        $this->db->limit($limit,$offset);
        return $products;
    }

    function find_by_tag($slug, $limit = null, $offset = 0) {
        $this->db->select('p.*,u.username');
        $this->db->join('tags c', 'pc.tag_id=c.id');
        $this->db->join('products p', 'pc.post_id=p.id');
        $this->db->join('users u', 'p.user_id=u.id');
        $this->db->where('p.status', 1);
        $this->db->where('c.slug', $slug);
        $this->db->group_by('pc.post_id');
        $this->db->order_by('p.published_at', 'desc');
        $products = $this->db->get('products_tags pc', $limit, $offset)->result_array();
        return $products;
    }

    function create($post) {
        $post['slug'] = url_title($post['title'], '-', true);
        $post['body'] = trim(preg_replace('/\s\s+/', ' ', $post['body']));
        $this->db->insert($this->table, $post);
    }

    function update($post, $id) {
        $post['slug'] = url_title($post['title'], '-', true);
        $post['body'] = trim(preg_replace('/\s\s+/', ' ', $post['body']));
        $this->db->where('id', $id);
        $this->db->update($this->table, $post);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    function find_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get($this->table, 1)->row_array();
    }

    function find_by_slug($slug) {
        $this->db->select('products.*,users.username,products_category.name,products_category.slug AS pc_slug');
        $this->db->join('users', 'users.id = products.user_id','left');
        $this->db->join('product_category_relation', 'product_category_relation.product_id = products.id','left');
        $this->db->join('products_category', 'products_category.id = product_category_relation.product_category_id','left');
        $this->db->where('products.slug', $slug);
        return $this->db->get($this->table, 1)->row_array();
    }
    
    /**
     * function to get product images by id
     * @param int $id
     * @return array
     */
    function product_thumbnails($id){
        if(!empty($id) && $id > 0){
            $this->db->select('image_name');
            $this->db->where('product_images.product_id', $id);
            $images = $this->db->get('product_images')->result_array();
            return $images;
        }
    }

    function all_urls() {
        $products = $this->db->select('id,title,slug')->where(array('status' => 1))->order_by('id', 'desc')->get($this->table)->result_array();
        $all_urls = array();
        if (!empty($products)) {
            foreach ($products as $post) {
                $all_urls['read/' . $post['slug']] = $post['title'];
            }
        }

        return $all_urls;
    }

}
