<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Product_category_model extends CI_Model {

    var $table = 'products_category';

    function find($limit = null, $offset = 0, $conditions = array()) {
        $products_category = $this->db->where($conditions)->order_by('name', 'asc')->get($this->table, $limit, $offset)->result_array();
        return $products_category;
    }

    function find_active() {
        $this->db->select('c.*');
        $this->db->join('products_category c', 'pc.category_id=c.id');
        $this->db->join('products p', 'pc.post_id=p.id');
        $this->db->where('c.status', 1);
        $this->db->where('p.status', 1);
        $this->db->group_by('pc.category_id');
        $this->db->order_by('c.name', 'asc');
        $products_category = $this->db->get('products_category pc')->result_array();
        return $products_category;
    }

    function create($category) {
        $category['slug'] = url_title($category['name'], '-', true);
        $this->db->insert($this->table, $category);
    }

    function update($category, $id) {
        if (!empty($category) && $id != '' && $id > 0) {
            $category['slug'] = url_title($category['name'], '-', true);
            $this->db->where('id', $id);
            $this->db->update($this->table, $category);
        }
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    function find_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get($this->table, 1)->row_array();
    }

    function find_by_slug($slug) {
        $this->db->where('slug', $slug);
        return $this->db->get($this->table, 1)->row_array();
    }

    function find_list() {
        $this->db->order_by('name', 'asc');
        $query = $this->db->get($this->table);
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $row) {
                $data[$row['id']] = $row['name'];
            }
        }
        return $data;
    }

    function get_sub_categories($id) {
        $this->db->select('pc.*');
        $this->db->where('pc.status', 1);
        $this->db->where('pc.parent_cat', $id);
        $this->db->order_by('pc.name', 'asc');
        $products_category = $this->db->get('products_category pc')->result_array();
        return $products_category;
    }

}
