<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Slider extends CI_Model {

    var $table = 'slider';

    function find($limit = null, $offset = 0, $user_id = null, $q = null)
    {
        $this->db->select('slider.*,users.username');
        $this->db->join('users', 'users.id = slider.user_id');
        if ($q != null) {
            $this->db->like('title', $q);
        }
        if ($user_id != null) {
            $this->db->where('user_id', $user_id);
        }
        $this->db->where('status', 1);
        $this->db->limit($limit, $offset);
        $this->db->order_by('order', 'ASC');
        $query = $this->db->get($this->table);

        return $query->result_array();
    }

    function create($post)
    {
        $this->db->insert($this->table, $post);
        return TRUE;
    }

    function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
        return TRUE;
    }

}
