<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Locations</h3>
            </div><!-- /.box-header -->
            <div class="box-body">
                <?php echo $this->session->flashdata('message'); ?>
                <p><a class="btn btn-default" href="<?php echo site_url('admin/locations/add') ?>">New Location</a></p>
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 10px">#</th>
                        <th>Title</th>
                        <th>Address</th>
                        <th>Published</th>
                        <th style="width: 100px">Action</th>
                    </tr>
                    <?php if (!empty($locations)): ?>
                        <?php $rowCounter = 1; foreach ($locations as $location): ?>
                            <tr>
                                <td><?php echo $rowCounter; ?></td>
                                <td><?php echo $location['title'] ?></td>
                                <td><?php echo $location['post_code'] ?></td>
                                <td><?php echo $location['address'] ?></td>
                                <td><?php echo $location['created_at'] ?></td>
                                <td>
                                    <a href="<?php echo site_url('admin/locations/edit/' . $location['id']) ?>"><span class="badge bg-green">edit</span></a>
                                    <a href="<?php echo site_url('admin/locations/delete/' . $location['id']) ?>" onclick="return confirm('Are you sure?')"><span class="badge bg-red">delete</span></a>
                                </td>
                            </tr>
                        <?php $rowCounter++; endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5">No record found</td></tr>
                    <?php endif; ?>
                </table>
            </div><!-- /.box-body -->
            <div class="box-footer clearfix">
                <?php echo $pagination ?>
            </div>
        </div><!-- /.box -->
    </div>
</div>