<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Member Files</h3>
            </div><!-- /.box-header -->
            <div class="box-body">
                <?php echo $this->session->flashdata('message'); ?>
                <p><a class="btn btn-default" href="<?php echo site_url('admin/member-files/add') ?>">Add New File</a></p>
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 10px">#</th>
                        <th>File Name</th>
                        <th>File</th>
                        <th>File Group</th>
                        <th>Added At</th>
                        <th style="width: 100px">Action</th>
                    </tr>
                    <?php if (!empty($files)): ?>
                        <?php foreach ($files as $file): ?>
                            <tr>
                                <td><?php echo $file['id'] ?></td>
                                <td><?php echo $file['file_name'] ?></td>
                                <td><a target="_blank" href="<?= base_url().$file['file_url'] ?>"><?php echo $file['file'] ?></a></td>
                                <td><?php echo $file['file_group_name'] ?></td>
                                <td><?php echo $file['created_at'] ?></td>
                                <td>
                                    <a href="<?php echo site_url('admin/member-files/edit/' . $file['id']) ?>"><span class="badge bg-green"><i class="fa fa-edit"></i></span></a>
                                    <a href="<?php echo site_url('admin/member-files/delete/' . $file['id']) ?>" onclick="return confirm('Are you sure?')"><span class="badge bg-red"><i class="fa fa-times"></i></span></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                            <tr><td class="text-center" colspan="6">No Record Found.</td></tr>
                    <?php endif; ?>
                </table>
            </div><!-- /.box-body -->
            <div class="box-footer clearfix">
                <?php echo $pagination ?>
            </div>
        </div><!-- /.box -->
    </div>
</div>