<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-12">
        <!-- general form elements -->
        <div class="box box-primary">
            <div class="box-header">
                <h3 class="box-title">New Product</h3>
            </div><!-- /.box-header -->
            <!-- form start -->
            <form role="form" action="<?php echo site_url('admin/products/add') ?>" enctype="multipart/form-data" method="post">
                <div class="box-body">
                    <?php echo message_box(validation_errors(), 'danger'); ?>
                    <div class="form-group">
                        <label for="post_name">Title</label>
                        <input type="text" name="title" class="form-control" id="post_name" placeholder="Title" value="<?php echo set_value('title'); ?>">
                    </div>
                    <div class="form-group">
                        <label for="post_body">Body</label>
                        <textarea name="body" class="form-control txteditor" id="post_body" placeholder="Body" rows="10"><?php echo set_value('body'); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="featured_image">Featured Image</label>
                        <input type="file" name="featured_image" value="<?php echo set_value('featured_image'); ?>" id="featured_image">
                        <div class="preview_featured_image"></div>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="product_images">Product Images (Select multiple images with extension jpg|gif|png only )</label>
                        <input type="file" name="images[]" multiple id="product_images">
                        <div class="gallery"></div>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="file_upload">Leaflet File Upload</label>
                        <input type="file" name="file_upload" id="file_upload" value="<?php echo set_value('file_upload'); ?>">
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="photo_spare_part">Photo/Spare Part File Upload</label>
                        <input type="file" name="photo_spare_part" id="photo_spare_part" value="<?php echo set_value('photo_spare_part'); ?>">
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="video_link">Video Link (Youtube)</label>
                        <input type="text" name="video_link" class="form-control" id="video_link" value="<?php echo set_value('video_link'); ?>">
                    </div>
                    <div class="form-group">
                        <label for="post_name">Publish Date</label>
                        <input type="text" name="published_at" class="form-control datepicker" data-date-format="yyyy-mm-dd" id="publish_date" placeholder="Publish Date" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="form-group">
                        <label for="product_order">Product Order</label>
                        <input type="text" maxlength="11" name="order" class="form-control" id="product_order" value="<?php echo set_value('order'); ?>">
                    </div>
                    <div class="form-group">
                        <label for="product_order">Show in Latest Products?</label>
                        <select class="form-control" name="is_front">
                            <option value="no">No</option>
                            <option value="yes">Yes</option>
                        </select>
                    </div>
                    <?php if ($this->ion_auth->is_admin()): ?>
                        <div class="form-group">
                            <label for="post_status">Status</label>
                            <?php
                            echo form_dropdown('status', $post_status, set_value('status'), array('class' => 'form-control'));
                            ?>
                        </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="post_status">Product Categories</label>
                        <?php
                        echo form_dropdown('category[]', $categories, null, array('class' => 'select2 form-control', 'multiple' => true));
                        ?>
                    </div>

                </div><!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">Submit</button> 
                    <button type="button" class="btn btn-default" onclick="javascript:history.back()">Back</button>
                </div>
            </form>
        </div><!-- /.box -->
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="assetsModal" tabindex="-1" role="dialog" aria-labelledby="assetsModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="assetsModalLabel">Assets Manager</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <ul class="thumbnails padding-top list-unstyled" id="assetsList">

                    </ul>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal" aria-hidden="true">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Line Control WYSIWYG -->
<script src="<?php echo $base_assets_url; ?>plugins/line_control_editor/editor.js"></script>
<script type="text/javascript">
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            $('.preview_featured_image').html('<img id="previewHolder" src="'+e.target.result+'" alt="Uploaded Image Preview Holder" width="250px" height="250px"/>');
        }

        reader.readAsDataURL(input.files[0]);
    }
}
$(document).ready(function () {
    $("#featured_image").change(function () {
        readURL(this);
    });
    $("button:submit").click(function () {
        $('.txteditor').text($('.txteditor').Editor("getText"));
    });

    var editor = $(".txteditor").Editor();
    $('.txteditor').Editor("setText", "<?php echo!empty($post['body']) ? addslashes($post['body']) : ''; ?>");
    
    // Multiple images preview in browser
    var imagesPreview = function(input, placeToInsertImagePreview) {

        if (input.files) {
            var filesAmount = input.files.length;

            for (i = 0; i < filesAmount; i++) {
                var reader = new FileReader();

                reader.onload = function(event) {
                    $($.parseHTML('<img class="img-thumbnail" width="150px" height="150px" style="margin-right:5px;">')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                }

                reader.readAsDataURL(input.files[i]);
            }
        }

    };

    $('#product_images').on('change', function() {
        imagesPreview(this, 'div.gallery');
    });
});
</script>
