<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-12">
        <!-- general form elements -->
        <div class="box box-primary">
            <div class="box-header">
                <h3 class="box-title">Edit Product</h3>
            </div><!-- /.box-header -->
            <!-- form start -->
            <form role="form" action="<?php echo site_url('admin/products/edit') ?>" enctype="multipart/form-data" method="post">
                <input type="hidden" name="id" value="<?php echo $product['id'] ?>">
                <div class="box-body">
                    <?php echo message_box(validation_errors(), 'danger'); ?>
                    <div class="form-group">
                        <label for="post_name">Title</label>
                        <input type="text" name="title" class="form-control" id="post_name" placeholder="Title" value="<?php echo set_value('title', isset($product['title']) ? $product['title'] : '') ?>">
                    </div>
                    <div class="form-group">
                        <label for="post_body">Body</label>
                        <textarea name="body" class="form-control txteditor" id="post_body" placeholder="Body" rows="10"><?php echo set_value('body', isset($product['body']) ? $product['body'] : '') ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="post_status">Featured Image</label>
                        <input type="hidden" name="old_featured_image" value="<?php echo $product['featured_image'] ?>" id="old_featured_image" />
                        <div class="preview_featured_image">
                            <?php if (!empty($product['featured_image'])): ?>
                                <img src="<?php echo BASE_URI . $product['featured_image'] ?>" class="img-responsive thumbnail" style="width:150px;height:150px;cursor:pointer">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="file" name="featured_image" value="<?php echo set_value('featured_image'); ?>" id="featured_image">
                        <div class="preview_featured_image"></div>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="product_images">Product Images (Select multiple images with extension jpg|gif|png only )</label>
                        <input type="file" name="images[]" multiple id="product_images">
                        <div class="gallery"></div>
                        <?php
                            foreach ($product_thumbnails as $key => $pt) {
                                echo '<img class="img img-thumbnail" width="150px" height="150px" src="/assets/product_images/'.$pt['image_name'].'" alt="'.$product['title'].'"/>';
                        } ?>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="file_upload">Leaflet File Upload</label>
                        <input type="file" name="file_upload" id="file_upload" value="<?php echo set_value('file_upload'); ?>">
                        <input type="hidden" name="old_file_upload" value="<?php echo $product['file_link'] ?>" id="old_file_upload" />
                        <?php if (!empty($product['file_link'])): ?>
                            <a href="<?php echo BASE_URI . $product['file_link'] ?>">Click to download link</a>
                        <?php endif; ?>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="photo_spare_part">Photo/Spare Part File Upload</label>
                        <input type="hidden" name="old_photo_spare_part" value="<?php echo $product['photo_sparepart_link'] ?>" id="old_photo_spare_part" />
                        <input type="file" name="photo_spare_part" id="photo_spare_part" value="<?php echo set_value('photo_spare_part'); ?>">
                         <?php if (!empty($product['photo_sparepart_link'])): ?>
                            <a href="<?php echo BASE_URI . $product['photo_sparepart_link'] ?>">Click to download link</a>
                        <?php endif; ?>
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="video_link">Video Link (Youtube)</label>
                        <input type="text" name="video_link" class="form-control" id="video_link" value="<?php echo set_value('video_link', isset($product['video_link']) ? $product['video_link'] : '') ?>">
                    </div>
                    <br />
                    <div class="form-group">
                        <label for="post_name">Publish Date</label>
                        <input type="text" name="published_at" class="form-control datepicker"  data-date-format="yyyy-mm-dd" id="post_name" placeholder="Publish Date" value="<?php echo set_value('published_at', isset($product['published_at']) ? $product['published_at'] : '') ?>">
                    </div>
                    <div class="form-group">
                        <label for="product_order">Product Order</label>
                        <input type="text" maxlength="11" name="order" class="form-control" id="product_order" value="<?php echo $product['order']; ?>">
                    </div>
                    <div class="form-group">
                        <label for="product_order">Show in Latest Products?</label>
                        <select class="form-control" name="is_front">
                            <option <?= ($product['is_front'] == 'no') ? 'selected="selected"' : '' ?> value="no">No</option>
                            <option <?= ($product['is_front'] == 'yes') ? 'selected="selected"' : '' ?> value="yes">Yes</option>
                        </select>
                    </div>
                    <?php if ($this->ion_auth->is_admin()): ?>
                        <div class="form-group">
                            <label for="post_status">Status</label>
                            <?php
                            echo form_dropdown('status', $post_status, set_value('status', isset($product['status']) ? $product['status'] : ''), array('class' => 'form-control'));
                            ?>
                        </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="post_status">Categories</label>
                        <?php
                        echo form_dropdown('category[]', $categories, $category_ids, array('class' => 'select2 form-control', 'multiple' => true));
                        ?>
                    </div>

                </div><!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">Submit</button> 
                    <button type="button" class="btn btn-default" onclick="javascript:history.back()">Back</button>
                </div>
            </form>
        </div><!-- /.box -->
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="assetsModal" tabindex="-1" role="dialog" aria-labelledby="assetsModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="assetsModalLabel">Assets Manager</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <ul class="thumbnails padding-top list-unstyled" id="assetsList">

                    </ul>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal" aria-hidden="true">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Line Control WYSIWYG -->
<script src="<?php echo $base_assets_url; ?>plugins/line_control_editor/editor.js"></script>
<script type="text/javascript">
$(document).ready(function () {
    $("button:submit").click(function () {
        $('.txteditor').text($('.txteditor').Editor("getText"));
    });

    var editor = $(".txteditor").Editor();
    $('.txteditor').Editor("setText", "<?php echo!empty($product['body']) ? addslashes($product['body']) : ''; ?>");
    
    // Multiple images preview in browser
    var imagesPreview = function(input, placeToInsertImagePreview) {

        if (input.files) {
            var filesAmount = input.files.length;

            for (i = 0; i < filesAmount; i++) {
                var reader = new FileReader();

                reader.onload = function(event) {
                    $($.parseHTML('<img class="img-thumbnail" width="150px" height="150px" style="margin-right:5px;">')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                }

                reader.readAsDataURL(input.files[i]);
            }
        }

    };

    $('#product_images').on('change', function() {
        imagesPreview(this, 'div.gallery');
    });
});
</script>
