<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Products</h3>
            </div><!-- /.box-header -->
            <div class="box-body">
                <?php echo $this->session->flashdata('message'); ?>
                <p class="pull-left"><a class="btn btn-default" href="<?php echo site_url('admin/products/add') ?>">New Product</a></p>
                <div class="pull-right">
                    <form class="form-inline" action="<?= base_url().'admin/products/index/'; ?>" method="get">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="text" class="form-control" id="search_query" name="q" placeholder="Enter product name">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Search</button>
                    </form>
                </div>
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 10px">#</th>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Published</th>
                        <th>Author</th>
                        <th>Product Order</th>
                        <th>Status</th>
                        <th style="width: 150px">Action</th>
                    </tr>
                    <?php if (!empty($products)): ?>
                        <?php foreach ($products as $product): ?>
                            <tr>
                                <td><?php echo $product['id'] ?></td>
                                <td><?php echo $product['title'] ?></td>
                                <td><?php echo $product['slug'] ?></td>
                                <td><?php echo $product['published_at'] ?></td>
                                <td><?php echo $product['username'] ?></td>
                                <td><?php echo $product['order'] ?></td>
                                <td><?php echo $post_status[$product['status']] ?></td>
                                <td>
                                    <a href="<?php echo site_url('admin/products/edit/' . $product['id']) ?>"><span class="badge bg-green">edit</span></a>
                                    <a href="<?php echo site_url('admin/products/delete/' . $product['id']) ?>" onclick="return confirm('Are you sure?')"><span class="badge bg-red">delete</span></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5">No record found</td></tr>
                    <?php endif; ?>
                </table>
            </div><!-- /.box-body -->
            <div class="box-footer clearfix">
                <?php echo $pagination ?>
            </div>
        </div><!-- /.box -->
    </div>
</div>