<div class="row">
    <div class="col-md-12">
        <!-- general form elements -->
        <div class="box box-primary">
            <div class="box-header">
                <h3 class="box-title">New Slide</h3>
            </div><!-- /.box-header -->
            <!-- form start -->
            <form role="form" action="<?php echo site_url('admin/sliders/add') ?>" method="post" enctype="multipart/form-data">
                <div class="box-body">
                    <?php echo message_box(validation_errors(), 'danger'); ?>
                    <div class="form-group">
                        <label for="slide_title">Slide Title</label>
                        <input type="text" maxlength="255" name="slide_title" class="form-control" id="slide_title" placeholder="Slide Title" value="<?php echo set_value('slide_title'); ?>">
                    </div>
                    <div class="form-group">
                        <label for="featured_image">Slide Image (Required size 1920*700)</label>
                        <input type="file" name="featured_image" value="<?php echo set_value('featured_image'); ?>" id="featured_image">
                        <div class="preview_featured_image"></div>
                    </div>
                   <div class="form-group">
                        <label for="order">Slide Order</label>
                        <input type="number" min="0" maxlength="11" name="order" class="form-control" id="order" value="0">
                    </div>
                    <?php if ($this->ion_auth->is_admin()): ?>
                        <div class="form-group">
                            <label for="post_status">Status</label>
                            <?php
                            echo form_dropdown('status', array(1 => 'Active',0 => 'Inactive'), set_value('status'), array('class' => 'form-control'));
                            ?>
                        </div>
                    <?php endif; ?>

                </div><!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" name="slider_add" value="1" class="btn btn-primary">Submit</button> 
                    <button type="button" class="btn btn-default" onclick="javascript:history.back()">Back</button>
                </div>
            </form>
        </div><!-- /.box -->
    </div>
</div>
<script type="text/javascript">
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            $('.preview_featured_image').html('<img id="previewHolder" src="'+e.target.result+'" alt="Uploaded Image Preview Holder" width="400px" height="300px"/>');
        }

        reader.readAsDataURL(input.files[0]);
    }
}

$(document).ready(function () {
    $("#featured_image").change(function () {
        readURL(this);
    });
})

</script>