<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<!-- slider Section Start -->
<div class="slider_section">
    <div class="owl-carousel owl-theme">
        <?php
        /*if (!empty($sliders)) :
            foreach ($sliders as $slider) :
            ?>
            <figure class="owl-item">
                <img src="<?= site_url().$slider['image']; ?>" alt="<?= $slider['title']; ?>" /> 
            </figure>
            <?php
            endforeach;*/
            ?>
        <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/1.jpg" alt="banner" /> </a>
        </figure>
        <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/2.jpg" alt="banner" /> 
        </figure>
        <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/3.jpg" alt="banner" /> </a>
        </figure>
          <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/4.jpg" alt="banner" /> 
        </figure>
          <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/5.jpg" alt="banner" /> </a>
        </figure>
          <figure class="owl-item">
            <img src="<?= base_url(); ?>assets/images/banner/6.jpg" alt="banner" /> 
        </figure>
    </div>
</div>
<!-- slider Section End -->

<!-- main_section start -->
<section class="main_section">
    <!-- Feature Section Strat -->
    <section class="feature">
        <div class="container">
            <div class="item-list">
                <div class="row">
                    <div class="col-md-3 col-sm-5 col-xs-10">
                        <div class="item">
                            <figure class="image-box">
                                <img src="<?= base_url(); ?>assets/images/feature/2.jpg" alt="">
                                <div class="overlay"></div>
                            </figure>
                            <div class="icon-box">
                                <img src="data:image/png;base64,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" style="margin-top: 18px;">
                                <!--<i class="icon flaticon-nature"></i>-->
                            </div>
                            <div class="content-box">
                                <h3>HEALTH SECURITY PRODUCTS </h3>
                                <p>Range of products for Public health / pest control fogging and spraying applications.</p>
                            </div>
                            <div class="feature-btn text-center">
                                <a href="<?= base_url(); ?>product-category/thermal-fogging-machine" class="read-more">read more</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-5 col-xs-10">
                        <div class="item">
                            <figure class="image-box">
                                <img src="<?= base_url(); ?>assets/images/feature/3.jpg" alt="">
                                <div class="overlay"></div>
                            </figure>
                            <div class="icon-box">
                                <img style="margin-top: 8px;" src="data:image/svg+xml;utf8;base64,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" />
                            </div>
                            <div class="content-box">
                                <h3>Farm equipment and machinery</h3>
                                <p>Products related to crop protection sprayers / dusters.</p>
                            </div>
                            <div class="feature-btn text-center">
                                <a href="<?= base_url(); ?>product-category/knapsack-sprayers" class="read-more">read more</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-5 col-xs-10">
                        <div class="item">
                            <figure class="image-box">
                                <img src="<?= base_url(); ?>assets/images/feature/1.jpg" alt="">
                                <div class="overlay"></div>
                            </figure>
                            <div class="icon-box">
                                <img style="margin-top: 8px;" src="data:image/svg+xml;utf8;base64,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" />
                                <!--<i class="icon flaticon-watering-can"></i>-->
                            </div>
                            <div class="content-box">
                                <h3>Power weeder and tiller </h3>
                                <p>Product related to land Preparation, power weeder and Brush cutters</p>
                            </div>
                            <div class="feature-btn text-center">
                                <a href="<?= base_url(); ?>product-category/power-weeder-and-tillers" class="read-more">read more</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-5 col-xs-10">
                        <div class="item">
                            <figure class="image-box">
                                <img src="<?= base_url(); ?>assets/images/feature/4.png" alt="">
                                <div class="overlay"></div>
                            </figure>
                            <div class="icon-box">
                                <img src="data:image/svg+xml;utf8;base64,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" style="margin-top: 18px;">
                                <!--<i class="icon flaticon-nature"></i>-->
                            </div>
                            <div class="content-box">
                                <h3>Brush cutter and chain saw </h3>
                                <p>Range of products for brush cutter and chain saw</p>
                            </div>
                            <div class="feature-btn text-center">
                                <a href="<?= base_url(); ?>product-category/brush-cutter-and-chain-saw" class="read-more">read more</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Feature Section End -->  
    <!-- welcome Section Start -->
    <section class="welcome-section">
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-sm-12 col-xs-12">
                    <div class="white-bg">
                        <div class="sec-title">
                            <h2>About <span>Foggers</span></h2>
                        </div>
                        <div class="content-box">
                            <?= word_limiter($aboutData['body'],80); ?>
                            <br>
                            <a href="<?= site_url().$aboutData['slug']; ?>" class="read-more">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-10 col-xs-12">
                    <div class="white-bg">
                        <div class="sec-title">
                            <h2>Latest <span>News</span></h2>
                            <div class="news-bar-slider">
                                <ul class="news-content">
                                    <?php foreach ($newsData as $key => $news) : ?>
                                        <li>
                                            <a href="<?= site_url().'read/'.$news['slug']; ?>" ><?= word_limiter($news['body'],30); ?></a>
                                            <span><i class="fa fa-clock-o"></i> <?= date('F ,Y', strtotime($news['published_at'])); ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- welcome Section End -->
    <!-- latest-product-section Strat -->
    <section class="latest-product-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="sec-title">
                        <h2>Latest <span>Product</span></h2>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="product_slide">
                        <div class="owl-carousel owl-theme">
                            <?php foreach ($productData as $key => $product) : ?>
                                <div class="single-item">
                                    <div class="img-holder">
                                        <?php if(!empty($product['featured_image'])) : ?>
                                            <img width="250px" height="300px" src="<?= site_url().$product['featured_image']; ?>" alt="products">
                                        <?php else: ?>
                                            <img width="250px" height="300px" src="<?= site_url().'assets/images/demo-image.png'; ?>" alt="products">
                                        <?php endif; ?>
                                        <div class="overlay">
                                            <div class="inner">
                                                <a href="<?= site_url().'product/'.$product['slug'] ?>" class="read-more">View Details</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="content-holder hvr-sweep-to-bottom">
                                        <h4><a href="<?= site_url().'product/'.$product['slug'] ?>"><?= $product['title'] ?></a></h4>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- latest-product-section End -->
    <!-- our-services Start -->
    <section class="our-services-gardener">
        <div class="container">
            <div class="sec-title">
                <h2>Company <span>Network</span></h2>
            </div>
            <div class="row clearfix">
                <?php if(!empty($locationData)) :
                    foreach ($locationData as $location):
                    ?>
                    <!--Start single service icon-->
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="single-service-item active">
                            <span class="top-border"></span>
                            <span class="right-border"></span>
                            <span class="bottom-border"></span>                        
                            <div class="service-left-bg"></div>
                            <div class="service-text">
                                <h4><a href="#"><?= $location['title'] ?></a></h4>
                                <p><?= $location['address'] ?></P>
                            </div>
                        </div>
                    </div>
                    <!--End single service icon-->
                <?php
                    endforeach;
                endif; ?>
                <a class="pull-right read-more" href="<?= site_url().'locations/' ?>">View All</a>
            </div>
        </div>
    </section>
    <!-- our-services End -->
</section>
<!-- main_section End -->
