<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!-- subBanner-section Start-->
<section class="subBanner-section" style="background-image:url(<?= base_url(); ?>assets/images/banner/1.jpg);">
    <div class="container">
        <h1>Locations</h1>
        <ol class="breadcrumb">
            <li><a href="<?= base_url(); ?>">Home</a></li>
            <li class="active">Locations</li>
        </ol>
        <div class="clearfix"></div>
    </div>
</section>
<!-- subBanner-section End-->

<!-- main_section start -->
<section class="main_section">
    <!-- product-section start -->
    <section class="about-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <script src="//code.jquery.com/jquery-1.10.2.min.js" type="text/javascript"></script>
                    <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyA7IZt-36CgqSGDFK8pChUdQXFyKIhpMBY" type="text/javascript"></script>

                    <div id="map-canvas" style="width: 100%; height: 500px;">
                    </div>
                    <!-- product-content End -->
                </div>
                <?php foreach ($locations as $key => $location) {
                $jsonArray[] = array(
                    'DisplayText' => $location['title'].'<br />'.strip_tags($location['address']),
                    'ADDRESS' => strip_tags($location['address']),
                    'LatitudeLongitude' => $location['lat'].','.$location['long'],
                    'MarkerId' => 'Customer',
                ); 
               }
               $locationData = json_encode($jsonArray);
               ?>
            </div>
        </div>
    </section>
    <!-- product-section End -->
</section>
<!-- main_section End -->
<script>
    var map;
    var geocoder;
    var marker;
    var people = new Array();
    var latlng;
    var infowindow;

    $(document).ready(function () {
        ViewCustInGoogleMap();
    });

    function ViewCustInGoogleMap() {

        var mapOptions = {
            center: new google.maps.LatLng(11.0168445, 76.9558321), // Coimbatore = (11.0168445, 76.9558321)
            zoom: 3,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);

        // Get data from database. It should be like below format or you can alter it.

//        var data = '[{ "DisplayText": "adcv", "ADDRESS": "Jamiya Nagar Kovaipudur Coimbatore-641042", "LatitudeLongitude": "10.9435131,76.9383790", "MarkerId": "Customer" },{ "DisplayText": "abcd", "ADDRESS": "Coimbatore-641042", "LatitudeLongitude": "11.0168445,76.9558321", "MarkerId": "Customer"}]';
        var data = '<?= $locationData; ?>';
        people = JSON.parse(data);

        for (var i = 0; i < people.length; i++) {
            setMarker(people[i]);
        }

    }

    function setMarker(people) {
        geocoder = new google.maps.Geocoder();
        infowindow = new google.maps.InfoWindow();
        if ((people["LatitudeLongitude"] == null) || (people["LatitudeLongitude"] == 'null') || (people["LatitudeLongitude"] == '')) {
            geocoder.geocode({'address': people["Address"]}, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    latlng = new google.maps.LatLng(results[0].geometry.location.lat(), results[0].geometry.location.lng());
                    marker = new google.maps.Marker({
                        position: latlng,
                        map: map,
                        draggable: false,
                        html: people["DisplayText"],
                        icon: "images/marker/" + people["MarkerId"] + ".png"
                    });
                    //marker.setPosition(latlng);
                    //map.setCenter(latlng);
                    google.maps.event.addListener(marker, 'click', function (event) {
                        infowindow.setContent(this.html);
                        infowindow.setPosition(event.latLng);
                        infowindow.open(map, this);
                    });
                } else {
                    alert(people["DisplayText"] + " -- " + people["Address"] + ". This address couldn't be found");
                }
            });
        } else {
            var latlngStr = people["LatitudeLongitude"].split(",");
            var lat = parseFloat(latlngStr[0]);
            var lng = parseFloat(latlngStr[1]);
            latlng = new google.maps.LatLng(lat, lng);
            marker = new google.maps.Marker({
                position: latlng,
                map: map,
                draggable: false, // cant drag it
                html: people["DisplayText"]    // Content display on marker click
                        //icon: "images/marker.png"       // Give ur own image
            });
            //marker.setPosition(latlng);
            //map.setCenter(latlng);
            google.maps.event.addListener(marker, 'click', function (event) {
                infowindow.setContent(this.html);
                infowindow.setPosition(event.latLng);
                infowindow.open(map, this);
            });
        }
    }
</script>