<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\masterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class authController extends Controller
{
    public function index()
    {
        $mstObj = new masterController();
        $mstObj->setMetaData(['title' => 'Log In - Admin - IHosting Mart Website', 'meta_desc' => 'Log In - Admin -', 'meta_keyword' => 'Log In - Admin']);
        $mstObj->setData(['page' => 'admin.login', 'page_title' => 'Admin - Log In - IHosting Mart Website', 'results' => null]);
        $mstObj->renderAdminPage();
    }

    public function auth(Request $request)
    {
        $token = $request->_token;
        if (isset($token) && !empty($token)) {
            $username = $request->username;
            $password  = $request->password;
            $validate_data = $request->validate([
                'username' => 'required',
                'password' => 'required|min:6|max:20',
            ]);

            if ($validate_data) {

                $data_user =  DB::table(TBL_ADMIN_USERS)->selectRaw("adm_id as id, adm_password as password,adm_status as status")->whereRaw("adm_user_name = '" . $username . "'")->get();
                $users_data = json_decode(json_encode($data_user), true);

                if (!empty($users_data)) {
                    if ($users_data[0]['status'] == 'ACTIVE') {
                        if (is_development()) {
                            $verify_password = ($password == $users_data[0]['password']);
                        } else {
                            $verify_password = Hash::check($password, $users_data[0]['password']);
                        }

                        if ($verify_password ==  true) {
                            DB::table(TBL_ADMIN_USERS)->where('adm_id', '=', $users_data[0]['id'])->update(['adm_last_login' => date('Y-m-d H:i:s')]);
                            $request->session()->put('admin_user_id', $users_data[0]['id']);
                            return  redirect(ADMIN_URL . 'dashboard')->with('message', 'success|Login Successful');
                        } else {
                            return  redirect()->back()->with('message', 'error|Wrong Password');
                        }
                    } else if ($users_data[0]['status'] == 'INACTIVE') {
                        return  redirect()->back()->with('message', 'error|Your Account is inactive Please contact to our support team.');
                    } else {
                        return  redirect()->back()->with('message', 'error|Account Not Found');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|User not found');
                }
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function forgetPassword()
    {
    }
    public function resetPassword()
    {
    }
}
