<?php


namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\masterController;

class enquariesController extends Controller
{
    public function index()
    {
        $data_contacts =  DB::table(TBL_CONTACTS)->selectRaw("*")->get();
        $contacts_data = json_decode(json_encode($data_contacts), true);
        $mstObj = new masterController();
        $mstObj->setMetaData(['title' => 'Dashboard - Admin - IHosting Mart Website', 'meta_desc' => 'Dashboard - Admin -', 'meta_keyword' => 'Dashboard - Admin']);
        $mstObj->setData(['page' => 'admin.enquiries.contacts_enquiry', 'page_title' => 'Contacts Enquiry Listing - Dashboard', 'results' => $contacts_data]);
        $mstObj->renderAdminDashboardPage();
    }

    public function packagesEnquiries()
    {
        $data_contacts =  DB::table(TBL_PACKAGE_ENQUIRY)->selectRaw("*")->get();
        $contacts_data = json_decode(json_encode($data_contacts), true);
        $mstObj = new masterController();
        $mstObj->setMetaData(['title' => 'Dashboard - Admin - IHosting Mart Website', 'meta_desc' => 'Dashboard - Admin -', 'meta_keyword' => 'Dashboard - Admin']);
        $mstObj->setData(['page' => 'admin.enquiries.packages_enquiry', 'page_title' => 'Packages Enquiry Listing - Dashboard', 'results' => $contacts_data]);
        $mstObj->renderAdminDashboardPage();
    }

    public function deleteContactsEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_CONTACTS)->where('con_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_CONTACTS)->where('con_id', '=', $user_id)->update(['con_is_deleted' => 1, 'con_deleted_date' => date('Y-m-d H:i:s')]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Contacts Enquiry Deleted Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Deleting Contacts Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function restoreContactsEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_CONTACTS)->where('con_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_CONTACTS)->where('con_id', '=', $user_id)->update(['con_is_deleted' => 0, 'con_deleted_date' => null]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Contacts Enquiry Restore Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Restore Contacts Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function deletePackagesEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=', $user_id)->update(['pen_is_deleted' => 1, 'pen_deleted_date' => date('Y-m-d H:i:s')]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Packages Enquiry Deleted Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Deleting Packages Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function restorePackagesEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=', $user_id)->update(['pen_is_deleted' => 0, 'pen_deleted_date' => null]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Packages Enquiry Restore Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Restore Packages Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function deletePermanentContactsEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_CONTACTS)->where('con_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_CONTACTS)->where('con_id', '=', $user_id)->delete();
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Contacts Enquiry Deleted Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Deleting Contacts Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function deletePermanentPackagesEnquiries($id)
    {
        if (isset($id)) {
            $user_id = decrypt($id);
            if (!empty($user_id)) {

                $data_user = DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=',  $user_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_PACKAGE_ENQUIRY)->where('pen_id', '=', $user_id)->delete();
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Packages Enquiry Deleted Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Deleting Packages Enquiry!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }
}
