<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\masterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class sitemenuController extends Controller
{

    public function index()
    {
        $query_results = DB::table(TBL_SITE_MENU)->selectRaw("*")->get();
        $data_res =   json_decode(json_encode($query_results), true);
        $mstObj = new masterController();
        $mstObj->setMetaData(['title' => 'Admin - Website Menu - IHosting Mart Website', 'meta_desc' => 'Admin - Website Menu', 'meta_keyword' => 'Admin - Website Menu']);
        $mstObj->setData(['page' => 'admin.site_menus.site_menu', 'page_title' => 'Admin - Website Menu', 'results' => $data_res]);
        $mstObj->renderAdminDashboardPage();
    }

    public function SiteMenu($id = null)
    {

        $parent_results = DB::table(TBL_SITE_MENU)->selectRaw("smu_id , smu_name")->whereRaw('smu_parent IS NULL')->get();
        $data_results =   json_decode(json_encode($parent_results), true);
        $parent_menu_list = [];
        foreach ($data_results as $key => $val) {
            $parent_menu_list[$val['smu_id']] = $val['smu_name'];
        }
        if (!empty($id)) {
            $id = decrypt($id);
            $query_results = DB::table(TBL_SITE_MENU)->selectRaw("*")->where('smu_id', $id)->get();
            $data_res =   json_decode(json_encode($query_results), true);
            $mstObj = new masterController();
            $mstObj->setMetaData(['title' => 'Edit Website Menu - IHosting Mart Website', 'meta_desc' => 'Edit - Website Menu', 'meta_keyword' => 'Admin - Website Menu']);
            $mstObj->setData(['page' => 'admin.site_menus.site_menu_form', 'page_title' => 'Edit Website Menu', 'results' => ['results' => $data_res, 'mode' => 'edit', 'data' => $parent_menu_list]]);
            $mstObj->renderAdminDashboardPage();
        } else {

            $mstObj = new masterController();
            $mstObj->setMetaData(['title' => 'Add Website Menu - IHosting Mart Website', 'meta_desc' => 'Add - Website Menu', 'meta_keyword' => 'Admin - Website Menu']);
            $mstObj->setData(['page' => 'admin.site_menus.site_menu_form', 'page_title' => 'Add Website Menu', 'results' => ['mode' => 'add', 'data' => $parent_menu_list]]);
            $mstObj->renderAdminDashboardPage();
        }
    }

    public function viewSiteMenu($id)
    {
        if (!empty($id)) {
            $id = decrypt($id);
            $query_results = DB::table(TBL_SITE_MENU)->selectRaw("*")->where('smu_id', $id)->get();
            $data_res =   json_decode(json_encode($query_results), true);
            $mstObj = new masterController();
            $mstObj->setMetaData(['title' => 'View Website Menu - IHosting Mart Website', 'meta_desc' => 'View - Website Menu', 'meta_keyword' => 'View Admin - Website Menu']);
            $mstObj->setData(['page' => 'admin.site_menus.site_menu_view', 'page_title' => 'View Website Menu', 'results' => $data_res[0]]);
            $mstObj->renderAdminDashboardPage();
        }
    }

    public function saveSiteMenu(Request $request)
    {

        $token =   $request->_token;
        $mode =  $request->mode;
        if (isset($token)) {
            $name = $request->name;
            $slug = $request->slug;
            $icon = $request->icon;
            $positions = $request->positions;
            $menu_parents = $request->menu_parents;
            $status = $request->status;
            $url = $request->url;
            $sortorder = $request->sortorder;
            $target = $request->target;

            if ($mode == 'edit') {

                $validate_data = $request->validate([
                    'name' => 'required',
                    'slug' => 'required',
                    'positions' => 'required',
                    'url' => 'required',
                    'sortorder' => 'required',
                ]);

                if ($validate_data) {


                    $smu_id = decrypt($request->smu_id);
                    $data_updated = [
                        'smu_modified_by' =>  session()->get('admin_user_id'),
                        'smu_modified_date' => date('Y-m-d H:i:s'),
                    ];
                    if (!empty($name)) {
                        $data_updated['smu_name'] =  $name;
                    }

                    if (!empty($slug)) {
                        $data_updated['smu_slug'] =  $slug;
                    }

                    if (!empty($sortorder)) {
                        $data_updated['smu_sort_order'] = $sortorder;
                    }

                    if (!empty($positions)) {
                        $data_updated['smu_position'] =  $positions;
                    }

                    if (!empty($url)) {
                        $data_updated['smu_url'] =  $url;
                    }

                    if (!empty($target)) {
                        $data_updated['smu_target'] =  1;
                    } else {
                        $data_updated['smu_target'] =  0;
                    }

                    if (!empty($icon)) {
                        $data_updated['smu_icon'] =  $icon;
                    }

                    if (!empty($menu_parents)) {
                        $data_updated['smu_parent'] = $menu_parents;
                    }
                    $data_updated['smu_status'] = $status;

                    if (!empty($data_updated)) {
                        $data =  DB::table(TBL_SITE_MENU)->where('smu_id', '=', $smu_id)->update($data_updated);
                    }

                    if (!empty($data)) {
                        return redirect()->back()->with('message', 'success|Website Menu details updated!');
                    } else {
                        return redirect()->back()->with('message', 'error|Failed To update Website Menu details');
                    }
                }
            } else {
                $validate_data = $request->validate([
                    'name' => 'required',
                    'slug' => 'required',
                    'positions' => 'required',
                    'url' => 'required',
                    'sortorder' => 'required',
                ]);
                if ($validate_data) {
                    $data_inserted = [
                        'smu_name' => $name,
                        'smu_slug' => $slug,
                        'smu_sort_order' =>  $sortorder,
                        'smu_position' => $positions,
                        'smu_url' => $url,
                        'smu_status' =>  $status,
                        'smu_created_by' =>  session()->get('admin_user_id'),
                        'smu_created_date' => date('Y-m-d H:i:s'),
                    ];


                    if (!empty($target)) {
                        $data_inserted['smu_target'] =  1;
                    } else {
                        $data_inserted['smu_target'] =  0;
                    }

                    if (!empty($icon)) {
                        $data_inserted['smu_icon'] =  $icon;
                    }

                    if (!empty($menu_parents)) {
                        $data_inserted['smu_parent'] = $menu_parents;
                    }
                    if (!empty($data_inserted)) {
                        $data =  DB::table(TBL_SITE_MENU)->insert($data_inserted);
                        $last_insert_id = DB::getPdo()->lastInsertId();
                    }

                    if (!empty($last_insert_id)) {
                        return redirect()->back()->with('message', 'success|New Website Menu details!');
                    } else {
                        return redirect()->back()->with('message', 'error|Failed To add Website Menu details');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data');
                }
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function deleteSiteMenu($id)
    {
        if (isset($id)) {
            $record_id = decrypt($id);
            if (!empty($record_id)) {

                $data_user = DB::table(TBL_SITE_MENU)->where('smu_id', '=',  $record_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_SITE_MENU)->where('smu_id', '=', $record_id)->update(['smu_is_deleted' => 1, 'smu_deleted_date' => date('Y-m-d H:i:s')]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Website Menu Deleted Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Deleting Website Menu!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function restoreSiteMenu($id)
    {
        if (isset($id)) {
            $record_id = decrypt($id);
            if (!empty($record_id)) {

                $data_user = DB::table(TBL_SITE_MENU)->where('smu_id', '=',  $record_id)->get("*");
                $users_data = (array)$data_user[0];

                if (!empty($users_data)) {
                    $data =  DB::table(TBL_SITE_MENU)->where('smu_id', '=', $record_id)->update(['smu_is_deleted' => 0, 'smu_deleted_date' => null]);
                    if ($data) {
                        return  redirect()->back()->with('message', 'success|Website Menu Restore Successfully!');
                    } else {
                        return  redirect()->back()->with('message', 'error|Error to Restore Website Menu!');
                    }
                } else {
                    return  redirect()->back()->with('message', 'error|Invalid Data!');
                }
            } else {
                return  redirect()->back()->with('message', 'error|Invalid Data');
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }
}
