<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class contactusController extends Controller
{
    public function index()
    {
        $masObj = new masterController();
        $masObj->setMetaData(['title' => 'Contact Us || i-Hosting Mart', 'meta_desc' => '', 'meta_keyword' => '']);
        $masObj->setData(['page' => 'contact']);
        $masObj->renderPage();
    }


    public function sendDetails(Request $request)
    {

        $token = $request->_token;
        $name = $request->name;
        $email = $request->email;
        $mobile = $request->mobile;
        $message = $request->message;
        if (isset($token) && !empty($token)) {
            $validate_data = $request->validate([
                'name' => 'required|min:3|max:50',
                'email' => 'required|email',
                'mobile' => 'required|numeric',
                'message' => 'required|min:10|max:500',
            ]);

            if ($validate_data) {
                $data_added = [
                    'con_name' =>  $name,
                    'con_mobile' =>  $mobile,
                    'con_email' => $email,
                    'con_message' => $message,
                    'con_date' => date('Y-m-d H:i:s'),
                ];
                if (!empty($data_added)) {
                    $data =  DB::table(TBL_CONTACTS)->insert($data_added);
                    $last_insert_id = DB::getPdo()->lastInsertId();
                }

                if (!empty($last_insert_id)) {
                    return redirect()->back()->with('message', 'success|Message send successfully!');
                } else {
                    return redirect()->back()->with('message', 'error|Failed To send message');
                }
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }

    public function sendPackageDetails(Request $request)
    {
        $token = $request->_token;
        $name = $request->name;
        $email = $request->email;
        $mobile = $request->mobile;
        $budget = $request->budget;
        $pages = $request->pages;
        $message = $request->message;
        $requirement = $request->requirement;
        if (isset($token) && !empty($token)) {
            $validate_data = $request->validate([
                'name' => 'required|min:3|max:50',
                'email' => 'required|email',
                'mobile' => 'required|numeric',
                'budget' => 'required',
                'pages' => 'required',
                'message' => 'required|min:10|max:1000',
            ]);

            if ($validate_data) {
                $data_added = [
                    'pen_fname' =>  $name,
                    'pen_mobile' =>  $mobile,
                    'pen_email' => $email,
                    'pen_budget' => $budget,
                    'pen_pages' => $pages,
                    'pen_details' => $message,
                    'pen_requirements' => json_encode(array_filter($requirement)),
                    'pen_created_date' => date('Y-m-d H:i:s'),
                ];
                if (!empty($data_added)) {
                    $data =  DB::table(TBL_PACKAGE_ENQUIRY)->insert($data_added);
                    $last_insert_id = DB::getPdo()->lastInsertId();
                }

                if (!empty($last_insert_id)) {
                    return redirect()->back()->with('message', 'success|Packages details send successfully!');
                } else {
                    return redirect()->back()->with('message', 'error|Failed To send Packages details');
                }
            }
        } else {
            return  redirect()->back()->with('message', 'error|Invalid Data');
        }
    }
}
