<?php

use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\DB;

if (!function_exists('get_client_ip')) {
    function get_client_ip()
    {
        if (getenv('HTTP_CLIENT_IP')) {
            $ip_address = getenv('HTTP_CLIENT_IP');
        } else if (getenv('HTTP_X_FORWARDED_FOR')) {
            $ip_address = getenv('HTTP_X_FORWARDED_FOR');
        } else if (getenv('HTTP_X_FORWARDED')) {
            $ip_address = getenv('HTTP_X_FORWARDED');
        } else if (getenv('HTTP_FORWARDED_FOR')) {
            $ip_address = getenv('HTTP_FORWARDED_FOR');
        } else if (getenv('HTTP_FORWARDED')) {
            $ip_address = getenv('HTTP_FORWARDED');
        } else if (getenv('REMOTE_ADDR')) {
            $ip_address = getenv('REMOTE_ADDR');
        } else {
            $ip_address = '';
        }
        return $ip_address;
    }
}

if (!function_exists('is_development')) {
    function is_development()
    {
        if (env('APP_ENV') == 'local') {
            return true;
        }
        return false;
    }
}

if (!function_exists('isUserLoggedIn')) {
    function isUserLoggedIn()
    {
        $val = false;
        if (session()->has('user_id')) {
            $val =  true;
        }
        return $val;
    }
}

if (!function_exists('isAdminLoggedIn')) {
    function isAdminLoggedIn()
    {
        $val = false;
        if (session()->has('admin_user_id')) {
            $val =  true;
        }
        return $val;
    }
}

if (!function_exists('uploadUrl')) {
    function uploadUrl($mode = '', $pic = '')
    {
        switch ($mode) {
            case 'admin_profile':
                $url = url(UPLOADS_ADMIN_IMG_FOLDER . $pic);
                break;
            case 'user_profile':
                $url = url(UPLOADS_USER_IMG_FOLDER . $pic);
                break;
            default:
                $url = url(UPLOADS_FOLDER . 'default.png');
                break;
        }
        return $url;
    }
}

if (!function_exists('getActiveTab')) {
    function getActiveTab($url)
    {
        $retval =  false;
        $current_url = url()->current();
        if (is_array($url)) {
            if (in_array($current_url, $url)) {
                $retval = true;
            }
        } else {
            if ($url == $current_url) {
                $retval = true;
            }
        }
        return $retval;
    }
}

if (!function_exists('getMobileData')) {
    function getMobileData($value)
    {
        if (!empty($value)) {
            $ph = explode('##', $value);
            $phone = '+' . $ph[1] . ' ' . $ph[2];
        } else {
            $phone = '-';
        }
        return $phone;
    }
}

if (!function_exists('change_to_custom_date')) {
    function change_to_custom_date($date, $df = DATE_USER_FORMAT_SMALL)
    {
        if (!empty($date)) {
            return date($df, strtotime($date));
        } else {
            return '-';
        }
    }
}

if (!function_exists('getUserDetails')) {
    function getUserDetails()
    {
        $users_data = [];
        if (isAdminLoggedIn()) {
            $data_user =  DB::table(TBL_ADMIN_USERS)->selectRaw("*")->whereRaw("adm_id = '" . session()->get('admin_user_id') . "' AND adm_status = 'ACTIVE'")->get();
            $users_data =   json_decode(json_encode($data_user), true);
        }
        return $users_data;
    }
}

if (!function_exists('getAdminName')) {
    function getAdminName($val)
    {
        if (!empty($val)) {
            $user = DB::select(" SELECT concat(adm_fname,' ',adm_lname) as admin_name  FROM " . TBL_ADMIN_USERS . " WHERE 1 AND adm_id = '" . $val . "'");
            $user =  json_decode(json_encode($user), true);
            $value = $user[0]['admin_name'];
        } else {
            $value = '';
        }
        return $value;
    }
}

