<link rel="stylesheet" href="{{ url('assets/intl-tel-input-master/build/css/intlTelInput.css') }}">

<link href="{{ url('assets/select2/select2.min.css') }}" rel="stylesheet" />
<style>
    .iti input,
    .iti input[type=tel] {
        padding-right: 55px;
        padding-left: 55px;
    }

    .error {
        color: red;
    }

    .img-upload-btn i {
        position: absolute;
        height: 16px;
        width: 16px;
        top: 32%;
        left: 50%;
        margin-top: -8px;
        margin-left: -8px;
    }
</style>
<?php

$results_data = $results['results'];
$mode = $results['mode'];
?>

<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">{{ $page_title }}</h5>

            <!-- General Form Elements -->
            <form action="{{ url(ADMIN_URL . 'save-profile-details') }}" method="post" id="edit-form" class="g-3"
                enctype="multipart/form-data">
                @csrf
                <div class="row mb-3">
                    <?php if($mode == 'edit'){ ?>
                    <input type="hidden" name="adm_id" value="{{ encrypt($results_data['adm_id']) }}">
                    <input type="hidden" name="old_img" value="{{ $results_data['adm_profile_pic'] ?? '' }}">
                    <?php } ?>

                    <input type="hidden" name="mode" value="{{ $mode }}">
                    <div class="col-sm-4">
                        <div class="img-upload-btn">
                            <?php if(!empty($results_data['adm_profile_pic'])) { ?>
                            <input type="file" name="images" onchange="preview()" id="imagess"
                                value="<?php echo $results_data['adm_profile_pic'] ?? old('images'); ?>" style="display: none">
                            <img id="frame" src="<?php echo !empty($results_data['adm_profile_pic']) ? uploadUrl('admin_profile', $results_data['adm_profile_pic']) : '#'; ?>"
                                class="img-thumbnail img-responsive mx-auto d-block rounded "
                                style="height: 100px; width: 100px;" />
                            <?php } else { ?>
                            <input type="file" name="images" onchange="preview()" id="imagess"
                                style="display: none">
                            <img id="frame" class="img-thumbnail img-responsive  mx-auto d-block rounded "
                                src="{{ uploadUrl() }}" style="height: 100px; width: 100px;" />
                            <?php }?>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="row mb-3">
                            <div class="col-sm-6">
                                <input type="text" id="fname" class="form-control " placeholder="First Name"
                                    name="fname" value="{{ $results_data['adm_fname'] ?? old('fname') }}">
                            </div>
                            <div class="col-sm-6">
                                <input type="text" id="lname" class="form-control " placeholder="Last Name"
                                    name="lname" value="{{ $results_data['adm_lname'] ?? old('lname') }}">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-sm-6">
                                <input type="text" id="uname"class="form-control" name="uname"
                                    value="{{ $results_data['adm_user_name'] ?? old('uname') }}"
                                    placeholder="User Name ">
                            </div>
                            <div class="col-sm-6">
                                <input type="text" id="scrname"class="form-control" name="scrname"
                                    value="{{ $results_data['adm_screen_name'] ?? old('scrname') }}"
                                    placeholder="Screen Name">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4">
                        <input type="text" id="uslug"class="form-control" name="uslug"
                            value="{{ $results_data['adm_slug'] ?? old('uslug') }}" placeholder="User Slug">
                        <input type="hidden" name="uslug_old" id="uslug_old"
                            value="{{ $results_data['adm_slug'] ?? '' }}">
                    </div>
                    <div class="col-sm-4">
                        <?php
                        
                        if (isset($results_data['adm_phone1'])) {
                            $phone_no1 = explode('##', $results_data['adm_phone1']);
                        }
                        
                        ?>
                        <input type="tel" name="mobile" class="form-control"
                            value="{{ $phone_no1[2] ?? old('mobile') }}" id="mobile" required
                            placeholder="Primary Mobile Address">
                        <input type="hidden" name="iso" id="iso" value="{{ $phone_no1[0] ?? old('iso') }}">
                        <input type="hidden" name="isd" id="isd"
                            value="{{ $phone_no1[1] ?? old('isd') }}">
                        <input type="hidden" name="phone_old" id="phone_old"
                            value="{{ $results_data['adm_phone1'] ?? '' }}">
                    </div>
                    <div class="col-sm-4">
                        <input type="email" name="email" class="form-control"
                            value="{{ $results_data['adm_email'] ?? old('email') }}" id="email" required
                            placeholder="Primary Email Address">
                        <input type="hidden" name="email_old" id="email_old"
                            value="{{ $results_data['adm_email'] ?? '' }}">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="utype" required=""
                            name="utype">
                            <option value="">Select Member Category</option>
                            <?php  foreach(ADMIN_MEMBER_TYPE as $mT => $mK){?>
                            <option value="<?= $mT ?>"
                                {{ ($results_data['adm_role'] ?? old('utype')) == $mT ? 'selected' : '' }}>
                                <?= $mK ?>
                            </option>
                            <?php }?>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="atype" required=""
                            name="atype">
                            <option value="">Select Admin Type</option>
                            <option value="1"
                                {{ ($results_data['adm_type'] ?? old('atype')) == 1 ? 'selected' : '' }}>
                                Master
                            </option>
                            <option value="0"
                                {{ ($results_data['adm_type'] ?? old('atype')) == 0 ? 'selected' : '' }}>
                                Admin
                            </option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="status" required=""
                            name="status">
                            <option value="">Select Status</option>
                            <?php  foreach(STATUS as $sK => $sV){?>
                            <option value="<?= $sK ?>"
                                {{ ($results_data['adm_status'] ?? old('status')) == $sK ? 'selected' : '' }}>
                                <?= $sV ?>
                            </option>
                            <?php }?>
                        </select>
                    </div>
                </div>

                <?php if($mode != 'edit'){ ?>
                <div class="row mb-3">
                    <div class="col-sm-6">
                        <input type="password" id="password" class="form-control" placeholder="Enter Password"
                            name="password" value="{{ old('password') }}">
                    </div>
                    <div class="col-sm-6">
                        <input type="password" id="confirm_password" class="form-control"
                            placeholder="Enter Confirm Password" name="confirm_password"
                            value="{{ old('confirm_password') }}">
                    </div>
                </div>
                <?php } ?>


                <div class="row mb-3">
                    <div class="col-sm-10">
                        <button type="submit" class="btn btn-sm btn-primary">Submit</button>
                        <a href="{{ url(ADMIN_URL . 'admins-list') }}"
                            class="btn btn-sm btn-warning text-white">Back</a>
                    </div>
                </div>

            </form><!-- End General Form Elements -->
        </div>
    </div>
</div>

<script src="{{ url('assets/select2/select2.min.js') }}"></script>

<script src="{{ url('assets/intl-tel-input-master/build/js/intlTelInput-jquery.min.js') }}"></script>


    
<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>
<script>
    var int = $("#mobile");
    <?php if(!empty($phone_no1[0])){ ?>
    var intt = int.intlTelInput({
        initialCountry: "<?= $phone_no1[0] ?>"
    });
    <?php } else { ?>
    var intt = int.intlTelInput({
        initialCountry: "In"
    });
    <?php } ?>

    $(".select2").select2();

    var getCode = int.intlTelInput('getSelectedCountryData');
    $('#iso').val(getCode.iso2);
    $('#isd').val(getCode.dialCode);

    int.on("countrychange", function(e) {
        var countryData = int.intlTelInput('getSelectedCountryData');
        $('#iso').val(countryData.iso2);
        $('#isd').val(countryData.dialCode);
    });

    $(document).ready(function() {
        $('#imagess').hide();
        $('#frame').on('click', function() {
            $('#imagess').trigger('click');
        });

        $('#edit-form').validate({
            rules: {
                fname: {
                    required: true,
                    minlength: 2,
                    maxlength: 18,
                },
                lname: {
                    required: true,
                    minlength: 2,
                    maxlength: 18,
                },
                uname: {
                    required: true,
                    minlength: 10,
                    maxlength: 18,
                },
                scrname: {
                    required: true,
                    minlength: 10,
                    maxlength: 18,
                },
                uslug: {
                    required: true,
                    minlength: 10,
                    maxlength: 20,
                    remote: {
                        url: "{{ url('/check-admin-user-slug') }}",
                        type: 'post',
                        dataType: "json",
                        data: {
                            '_token': '{{ csrf_token() }}',
                            'old_val': function() {
                                return $('#uslug_old').val();
                            }
                        },
                    }
                },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "{{ url('/check-admin-mobile-email') }}",
                        type: 'post',
                        dataType: "json",
                        data: {
                            '_token': '{{ csrf_token() }}',
                            'mode': 'email',
                            'old_val': function() {
                                return $('#email_old').val();
                            }
                        },
                    }
                },
                mobile: {
                    required: true,
                    digits: true,
                    minlength: function() {
                        if ($('#isd').val() == 91) {
                            return 10;
                        } else {
                            return 6;
                        }
                    },
                    maxlength: function() {
                        if ($('#isd').val() == 91) {
                            return 10;
                        } else {
                            return 20;
                        }
                    },
                    remote: {
                        url: "{{ url('/check-admin-mobile-email') }}",
                        type: 'post',
                        dataType: "json",
                        data: {
                            '_token': '{{ csrf_token() }}',
                            'mode': 'phone',
                            'old_val': function() {
                                return $('#phone_old').val();
                            },
                            'keyword': function() {
                                return $('#iso').val() + '##' + $('#isd').val() + '##' + $(
                                    '#mobile').val();
                            }
                        }
                    }
                },
                utype: {
                    required: true,
                },
                atype: {
                    required: true,
                },
            },
            messages: {
                fname: {
                    required: "First name must be required",
                    minlength: "First name must be minimum 2 character",
                    maxlength: "First name must be maximum 18 character",
                },
                lname: {
                    required: "Last name must be required",
                    minlength: "Last name must be minimum 2 character",
                    maxlength: "Last name must be maximum 18 character",
                },
                uname: {
                    required: "User name must be required",
                    minlength: "User name must be minimum 10 character",
                    maxlength: "User name must be maximum 18 character",
                },
                scrname: {
                    required: "Screen name must be required",
                    minlength: "Screen name must be minimum 10 character",
                    maxlength: "Screen name must be maximum 18 character",
                },
                uslug: {
                    required: "User Slug must be required",
                    minlength: "User Slug must be minimum 10 character",
                    maxlength: "User Slug must be maximum 20 character",
                },
                email: {
                    required: "Email Address Must be required",
                    email: "Email Address Must be Valid",
                },
                mobile: {
                    required: "Mobile Number Must be required",
                    digits: "Mobile Number Must be Numeric",
                },
                utype: {
                    required: "Member Type Must be required",
                },
                atype: {
                    required: "Admin Type Must be required",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });


    function preview() {
        frame.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
