<?php
$user_details = getUserDetails();

?>
<div class="col-lg-12 col-md-12 col-sm-12">

    <div class="card">
        <div class="card-body">


            <div class="col-sm-12">
                <h5 class="card-title">{{ $page_title }}</h5>
                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                <a class="btn btn-md btn-success" href="{{ url(ADMIN_URL . 'profile-details/') }}"
                    style="float:right; padding-left:10px;padding-right:10px;" title="add new Profile">
                    <i class="fa fa-plus"></i>
                </a>
                <?php } ?>
            </div>

            <!-- Table with stripped rows -->
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Name</th>
                        <th scope="col">Email</th>
                        <th scope="col">Mobile</th>
                        <th scope="col">Role</th>
                        <th scope="col">Status</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($results) && !empty($results)) { ?>
                    <?php  $start_counter = 1;
                         foreach ($results as $rK => $rV) { ?>
                    <tr>
                        <td scope="row">{{ $start_counter++ }}</td>
                        <td>{{ $rV['adm_fname'] . ' ' . $rV['adm_lname'] }}</td>
                        <td>{{ $rV['adm_email'] }}</td>
                        <td>{{ getMobileData($rV['adm_phone1']) }}</td>
                        <td>{{ ucwords($rV['adm_role']) }}</td>
                        <td>{{ STATUS[$rV['adm_status']] }}</td>
                        <td>
                            <div class="btn-group">
                                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                                <a class="btn btn-sm btn-primary" style="margin-right: 5px; padding:5px;"
                                    title="Click to edit Profile"
                                    href="{{ url(ADMIN_URL . 'profile-details/' . encrypt($rV['adm_id'])) }}">
                                    <i class="fa fa-edit"></i>
                                </a>
                                <?php } ?>

                                <a class="btn btn-sm btn-info" style="margin-right: 5px; padding:5px;"
                                    title="Click to view Profile"
                                    href="{{ url(ADMIN_URL . 'view-profile-details/' . encrypt($rV['adm_id'])) }}">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                                <?php if(isset($rV['adm_is_deleted']) && ($rV['adm_is_deleted'] == 0)) { ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to delete"
                                    href="{{ url(ADMIN_URL . 'delete-profile-details/' . encrypt($rV['adm_id'])) }}">
                                    <i class="fa fa-trash"></i>
                                </a>
                                <?php }else{ ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to restore"
                                    href="{{ url(ADMIN_URL . 'restore-profile-details/' . encrypt($rV['adm_id'])) }}">
                                    <i class="fa fa-trash-restore-alt"></i>
                                </a>
                                <?php } ?>
                                <?php } ?>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <span>
                                Created By:
                                <?= isset($rV['adm_created_by']) ? getAdminName($rV['adm_created_by']) . ' ' . $rV['adm_created_date'] : '-' ?>
                            </span>
                        </td>
                        <td colspan="3">
                            <span>
                                Modified By:
                                <?= isset($rV['adm_modifiedby']) ? getAdminName($rV['adm_modifiedby']) . ' ' . $rV['adm_modified_date'] : '-' ?>
                            </span>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php } else { ?>
                    <tr>
                        <td colspan="7" style="text-align:center">
                            <?php echo NO_RECORDS_FOUND; ?>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
            <!-- End Table with stripped rows -->

        </div>
    </div>


</div>
