

<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <!-- General Form Elements -->
            <form action="{{ url(ADMIN_URL . 'save-profile-password') }}" method="post" id="edit-form" class="g-3"
                enctype="multipart/form-data">
                @csrf
                <div class="row mb-3">
                    <input type="hidden" name="adm_id" value="{{ encrypt($results['adm_id']) }}">
                    <div class="col-sm-4">
                        <input type="password" id="password" class="form-control" placeholder="Enter Current Password"
                            name="password" value="{{ old('password') }}">
                    </div>
                    <div class="col-sm-4">
                        <input type="password" id="new_password" class="form-control" placeholder="Enter New Password"
                            name="new_password" value="{{ old('new_password') }}">
                    </div>
                    <div class="col-sm-4">
                        <input type="password" id="confirm_password" class="form-control"
                            placeholder="Enter Confirm Password" name="confirm_password"
                            value="{{ old('confirm_password') }}">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-10">
                        <button type="submit" class="btn btn-sm btn-primary">Submit</button>
                        <a href="{{ url(ADMIN_URL) }}" class="btn btn-sm btn-warning text-white">Back</a>
                    </div>
                </div>
            </form>
            <!-- End Change Password Form -->
        </div>
    </div>
</div>

<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>


<script>
    $(document).ready(function() {
        $('#edit-form').validate({
            rules: {
                password: {
                    required: true,
                    minlength: 6,
                    maxlength: 18,
                },
                new_password: {
                    required: true,
                    minlength: 6,
                    maxlength: 18,
                },
                confirm_password: {
                    required: true,
                    minlength: 6,
                    maxlength: 18,
                }
            },
            messages: {
                password: {
                    required: "Password must be required",
                    minlength: "Password must be minimum 6 character",
                    maxlength: "Password must be maximum 18 character",
                },
                new_password: {
                    required: "New Password must be required",
                    minlength: "New Password must be minimum 6 character",
                    maxlength: "New Password must be maximum 18 character",
                },
                confirm_password: {
                    required: "Confirm Password must be required",
                    minlength: "Confirm Password must be minimum 6 character",
                    maxlength: "Confirm Password must be maximum 18 character",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });
</script>
