<?php
$user_details = getUserDetails();

?>

<!-- Page Wrapper -->
<div id="wrapper">

    <!-- Sidebar -->
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

        <!-- Sidebar - Brand -->
        <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ url(ADMIN_URL) }}">
            <div class="sidebar-brand-icon ">
                <img src="{{ url('assets/img/icon/icon1.png') }}" alt="" class="img rounded-circle" width="50%"
                    height="auto">
            </div>
            <div class="sidebar-brand-text mx-3">I Hosting Mart</div>
        </a>

        <!-- Divider -->
        <hr class="sidebar-divider my-0">

        <!-- Nav Item - Dashboard -->
        <li class="nav-item active">
            <a class="nav-link" href="{{ url(ADMIN_URL) }}">
                <i class="fas fa-fw fa-tachometer-alt"></i>
                <span>Dashboard</span></a>
        </li>
        <!-- Divider -->
        <hr class="sidebar-divider">

        <!-- Heading -->
        <div class="sidebar-heading">
            Website Menu Settings
        </div>
        <li class="nav-item ">
            <a class="nav-link" href="{{ url(ADMIN_URL . 'site-menu-settings') }}">
                <i class="fas fa-fw fa-cog"></i>
                <span>Website Menu Settings</span></a>
        </li>
        <?php if(isset($user_details[0]['adm_role']) && (($user_details[0]['adm_role'] == 'master') || ($user_details[0]['adm_role'] == 'admin')) ){ ?>

        <!-- Divider -->
        <hr class="sidebar-divider">

        <!-- Heading -->
        <div class="sidebar-heading">
            Admins
        </div>

        <!-- Nav Item - Pages Collapse Menu -->
        <!-- Nav Item - Dashboard -->
        <li class="nav-item ">
            <a class="nav-link" href="{{ url(ADMIN_URL . 'admins-list') }}">
                <i class="fas fa-fw fa-cog"></i>
                <span>Admins Members</span></a>
        </li>
        <?php } ?>

        <?php if(isset($user_details[0]['adm_role']) && ($user_details[0]['adm_role'] != 'calling') && ($user_details[0]['adm_role'] != 'support') ){ ?>
        <!-- Divider -->
        <hr class="sidebar-divider">

        <!-- Heading -->
        <div class="sidebar-heading">
            Settings
        </div>

        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilities"
                aria-expanded="true" aria-controls="collapseUtilities">
                <i class="fas fa-fw fa-wrench"></i>
                <span>Website Settings</span>
            </a>
            <div id="collapseUtilities" class="collapse" aria-labelledby="headingUtilities"
                data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Website Settings:</h6>
                    <a class="collapse-item" href="{{ url(ADMIN_URL . 'website-meta-details') }}">Meta Details
                        Settings</a>
                    <a class="collapse-item" href="{{ url(ADMIN_URL . 'website-genral-details') }}">General
                        Settings</a>
                    <a class="collapse-item" href="{{ url(ADMIN_URL . 'website-main-details') }}">Main
                        Settings</a>
                </div>
            </div>
        </li>

        <?php } ?>


        <?php if (isset($user_details[0]['adm_role']) && ($user_details[0]['adm_role'] != 'editor') ) { ?>
        <!-- Divider -->
        <hr class="sidebar-divider">

        <!-- Heading -->
        <div class="sidebar-heading">
            Enquiries
        </div>

        <!-- Nav Item - Pages Collapse Menu -->
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapsePages"
                aria-expanded="true" aria-controls="collapsePages">
                <i class="fas fa-fw fa-paper-plane"></i>
                <span>Enquiry</span>
            </a>
            <div id="collapsePages" class="collapse" aria-labelledby="headingPages" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Contact Us & Packages</h6>
                    <a class="collapse-item" href="{{ url(ADMIN_URL . 'contacts-enquiry') }}">Contact Us Enquiry</a>
                    <a class="collapse-item" href="{{ url(ADMIN_URL . 'packages-enquiry') }}">Package Enquiry</a>
                </div>
            </div>
        </li>

        <?php } ?>
        <!-- Divider -->
        <hr class="sidebar-divider d-none d-md-block">

        <!-- Sidebar Toggler (Sidebar) -->
        <div class="text-center d-none d-md-inline">
            <button class="rounded-circle border-0" id="sidebarToggle"></button>
        </div>
    </ul>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">
        <!-- Main Content -->
        <div id="content">
            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                <!-- Sidebar Toggle (Topbar) -->
                <button id="sidebarToggleTop" class="btn btn-link rounded-circle mr-3">
                    <i class="fa fa-bars"></i>
                </button>
                <!-- Topbar Navbar -->
                <ul class="navbar-nav ml-auto">
                    <!-- Nav Item - Messages -->
                    <?php if(isset($user_details[0]['adm_role']) && ($user_details[0]['adm_role'] != 'editor') ){ ?>
                    <li class="nav-item dropdown no-arrow mx-1">
                        <a class="nav-link dropdown-toggle" href="#" id="messagesDropdown" role="button"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-envelope fa-fw"></i>
                            <!-- Counter - Messages -->
                            <span class="badge badge-danger badge-counter">7</span>
                        </a>
                        <!-- Dropdown - Messages -->
                        <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
                            aria-labelledby="messagesDropdown">
                            <h6 class="dropdown-header">
                                Message Center
                            </h6>
                            <a class="dropdown-item d-flex align-items-center" href="#">
                                <div class="font-weight-bold">
                                    <div class="text-truncate">Hi there! I am wondering if you can help me with a
                                        problem I've been having.</div>
                                    <div class="small text-gray-500">1 uc k</div>
                                </div>
                            </a>
                            <a class="dropdown-item text-center small text-gray-500"
                                href="{{ url('/contacts-list') }}">Read More
                                Messages</a>
                        </div>
                    </li>
                    <?php }?>

                    <div class="topbar-divider d-none d-sm-block"></div>

                    <!-- Nav Item - User Information -->
                    <li class="nav-item dropdown no-arrow">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span
                                class="mr-2 d-none d-lg-inline text-gray-600 small">{{ $user_details[0]['adm_screen_name'] }}</span>

                            <img src="<?= isset($user_details[0]['adm_profile_pic']) ? uploadUrl('admin_profile', $user_details[0]['adm_profile_pic']) : uploadUrl() ?>"
                                alt="Profile" class="img img-profile rounded-circle">
                        </a>
                        <!-- Dropdown - User Information -->
                        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                            aria-labelledby="userDropdown">
                            <a class="dropdown-item"
                                href="{{ url(ADMIN_URL . 'profile-details/' . encrypt(session()->get('admin_user_id'))) }}">
                                <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                Profile
                            </a>
                            <a class="dropdown-item"
                                href="{{ url(ADMIN_URL . 'change-password/' . encrypt(session()->get('admin_user_id'))) }}">
                                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                Change Password
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="{{ url(ADMIN_URL . 'logout') }}">
                                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                Logout
                            </a>
                        </div>
                    </li>

                </ul>

            </nav>
            <!-- End of Topbar -->
