<?php
$user_details = getUserDetails();

?>
<div class="col-lg-12 col-md-12 col-sm-12">

    <div class="card">
        <div class="card-body">


            <div class="col-sm-12">
                <h5 class="card-title">{{ $page_title }}</h5>
            </div>

            <!-- Table with stripped rows -->
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Name</th>
                        <th scope="col">Email</th>
                        <th scope="col">Mobile</th>
                        <th scope="col">Received Date</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($results) && !empty($results)) { ?>
                    <?php  $start_counter = 1;
                         foreach ($results as $rK => $rV) { ?>
                    <tr>
                        <td scope="row" rowspan="2">{{ $start_counter++ }}</td>
                        <td>{{ $rV['con_name'] }}</td>
                        <td>{{ $rV['con_email'] }}</td>
                        <td>{{ $rV['con_mobile'] }}</td>
                        <td>{{ $rV['con_date'] }}</td>
                        <td>
                            <div class="btn-group">
                                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                                <?php if(isset($rV['con_is_deleted']) && ($rV['con_is_deleted'] == 0)) { ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to delete"
                                    href="{{ url(ADMIN_URL . 'delete-contacts-enquiry/' . encrypt($rV['con_id'])) }}">
                                    <i class="fa fa-trash"></i>
                                </a>
                                <?php }else{ ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to restore"
                                    href="{{ url(ADMIN_URL . 'restore-contacts-enquiry/' . encrypt($rV['con_id'])) }}">
                                    <i class="fa fa-trash-restore-alt"></i>
                                </a>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to restore"
                                    href="{{ url(ADMIN_URL . 'delete-permanent-contacts-enquiry/' . encrypt($rV['con_id'])) }}">
                                    <i class="fa fa-trash"></i>
                                </a>
                                <?php } ?>
                                <?php } ?>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5">
                            <strong>Message: </strong>
                            {{ $rV['con_message'] }}
                        </td>
                    </tr>
                    <?php } ?>
                    <?php } else { ?>
                    <tr>
                        <td colspan="6" style="text-align:center">
                            <?php echo NO_RECORDS_FOUND; ?>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
            <!-- End Table with stripped rows -->

        </div>
    </div>


</div>
