<body class="bg-gradient-primary">
    <div class="container">
        <!-- Outer Row -->
        <div class="row justify-content-center">
            <div class="col-xl-3 col-lg-4 col-md-3"> </div>
            <div class="col-xl-6 col-lg-4 col-md-6">
                <div class="card o-hidden border-0 shadow-lg my-5">
                    
                    <?php
                    if (Session::has('message')) {
                        [$type, $message] = explode('|', Session::get('message'));
                        $type = $type == 'error' ? 'danger' : 'success';
                        echo sprintf('<div class="alert alert-%s alert-dismissible fade show" role="alert">%s <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>', $type, $message);
                    }
                    ?>
                    @foreach ($errors->all() as $error)
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">{{ $error }} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
                    @endforeach
                    <div class="card-body p-0">
                        <!-- Nested Row within Card Body -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h4 text-gray-900 mb-4">Welcome Back!</h1>
                                    </div>
                                    <form class="user" id="login-form" action="{{ url('admin/auth') }}" method="POST">
                                        @csrf
                                        <div class="form-group">
                                            <input type="text" class="form-control form-control-user" name="username"
                                                placeholder="Enter username">
                                        </div>
                                        <div class="form-group">
                                            <input type="password" class="form-control form-control-user" name="password" placeholder="Password">
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-user btn-block">
                                            Login
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-3"> </div>
        </div>
    </div>

    
<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>

<script>
    $('#login-form').validate({
        rules: {
            username: {
                required: true,
            },
            password: {
                required: true,
                minlength: 6,
                maxlength: 20
            }
        },
        messages: {
            username: {
                required: "Username Must be required",
            },
            password: {
                required: "Password Must be required",
                minlength: "Password Must be minimum 6 character",
                maxlength: "Password Must be maximum 20 character",
            },
        },
        submitHandler: function(form) {
            form.submit();
        }
    });


    function togglePassword(_this) {
        $(_this).toggleClass('bi-eye-slash-fill');
        var s_this = $(_this).next().next('input').attr('type');
        attr = (s_this == 'password') ? 'text' : 'password';
        $(_this).next().next('input').attr('type', attr);
    }
</script>
