<?php
$user_details = getUserDetails();

?>
<div class="col-lg-12 col-md-12 col-sm-12">

    <div class="card">
        <div class="card-body">

            <div class="col-sm-12">
                <h5 class="card-title">{{ $page_title }}</h5>
                <a class="btn btn-md btn-success" href="{{ url(ADMIN_URL . 'add-site-menu-settings/') }}"
                    style="float:right; padding-left:10px;padding-right:10px;" title="add new site menu">
                    <i class="fa fa-plus"></i>
                </a>
            </div>

            <!-- Table with stripped rows -->
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Site Name</th>
                        <th scope="col">Site Slug</th>
                        <th scope="col">Sort Order</th>
                        <th scope="col">Position</th>
                        <th scope="col">Status</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($results) && !empty($results)) { ?>
                    <?php  $start_counter = 1;
                         foreach ($results as $rK => $rV) { ?>
                    <tr>
                        <td>{{ $start_counter++ }}</td>
                        <td>{{ $rV['smu_name'] }}</td>
                        <td>{{ $rV['smu_slug'] }}</td>
                        <td>{{ $rV['smu_sort_order'] }}</td>
                        <td>{{ $rV['smu_position'] }}</td>
                        <td>{{ WEBSITE_STATUS_LABEL[$rV['smu_status']] }}</td>
                        <td>
                            <div class="btn-group">
                                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                                <a class="btn btn-sm btn-primary" style="margin-right: 5px; padding:5px;"
                                    title="Click to edit site menu"
                                    href="{{ url(ADMIN_URL . 'add-site-menu-settings/' . encrypt($rV['smu_id'])) }}">
                                    <i class="fa fa-edit"></i>
                                </a>
                                <?php } ?>

                                <a class="btn btn-sm btn-info" style="margin-right: 5px; padding:5px;"
                                    title="Click to view site menu"
                                    href="{{ url(ADMIN_URL . 'view-site-menu-settings/' . encrypt($rV['smu_id'])) }}">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <?php if(isset($user_details[0]['adm_type']) && ($user_details[0]['adm_type'] == 1)) { ?>
                                <?php if(isset($rV['smu_is_deleted']) && ($rV['smu_is_deleted'] == 0)) { ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to delete"
                                    href="{{ url(ADMIN_URL . 'delete-site-menu-settings/' . encrypt($rV['smu_id'])) }}">
                                    <i class="fa fa-trash"></i>
                                </a>
                                <?php }else{ ?>
                                <a class="btn btn-sm btn-danger" style="margin-right: 5px; padding:5px;"
                                    title="Click to restore"
                                    href="{{ url(ADMIN_URL . 'restore-site-menu-settings/' . encrypt($rV['smu_id'])) }}">
                                    <i class="fa fa-trash-restore-alt"></i>
                                </a>
                                <?php } ?>
                                <?php } ?>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php } else { ?>
                    <tr>
                        <td colspan="7" style="text-align:center">
                            <?php echo NO_RECORDS_FOUND; ?>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
            <!-- End Table with stripped rows -->

        </div>
    </div>


</div>
